/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockCommonPlant;
import org.betterx.betternether.interfaces.SurvivesOnGravel;
import org.betterx.betternether.registry.NetherItems;

public class BlockAgave
extends BlockCommonPlant
implements BehaviourPlant,
AddMineableShears,
SurvivesOnGravel {
    private static final VoxelShape SHAPE = BlockAgave.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final RandomSource RANDOM = new LegacyRandomSource(3326157953L);

    public BlockAgave() {
        super(BehaviourBuilders.createCactus((MapColor)MapColor.TERRACOTTA_ORANGE, (boolean)false).requiresCorrectToolForDrops().noCollission().destroyTime(0.4f).instabreak().offsetType(BlockBehaviour.OffsetType.XZ));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.getOffset(view, pos);
        return SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if ((Integer)state.getValue((Property)BlockCommonPlant.AGE) > 1) {
            entity.hurt(world.damageSources().cactus(), 1.0f);
        }
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if ((Integer)state.getValue((Property)BlockCommonPlant.AGE) == 3) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this, MHelper.randRange(1, 2, RANDOM)), new ItemStack((ItemLike)NetherItems.AGAVE_LEAF, MHelper.randRange(2, 5, RANDOM))});
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.canSurviveOnTop(world, pos);
    }
}

