/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnNetherGround;

public class BlockBlackBush
extends BlockBaseNotFull
implements BonemealableBlock,
SurvivesOnNetherGround,
BehaviourPlant {
    private static final VoxelShape SHAPE = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.625, (double)0.8125);

    public BlockBlackBush() {
        super(Materials.NETHER_PLANT.mapColor(MapColor.COLOR_BLACK));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.canSurviveOnTop(world, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockBlackBush.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.asItem()));
    }
}

