/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnBoneBlocks;

public class BlockBoneMushroom
extends BlockBaseNotFull
implements SurvivesOnBoneBlocks,
BehaviourPlant {
    private static final VoxelShape SHAPE_NORTH = BlockBoneMushroom.box((double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = BlockBoneMushroom.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)8.0);
    private static final VoxelShape SHAPE_WEST = BlockBoneMushroom.box((double)8.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_EAST = BlockBoneMushroom.box((double)0.0, (double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_UP = BlockBoneMushroom.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final IntegerProperty AGE = BlockProperties.AGE_THREE;

    public BlockBoneMushroom() {
        super(Materials.NETHER_PLANT.mapColor(MapColor.COLOR_LIGHT_GREEN).randomTicks());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING, AGE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_UP;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (direction == Direction.DOWN) {
            return false;
        }
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return this.isSurvivable(blockState);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 2 && random.nextInt(32) == 0) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = this.defaultBlockState();
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] directions = ctx.getNearestLookingDirections();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction2;
            Direction direction = directions[i];
            if (direction == Direction.UP || !(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)(direction2 = direction.getOpposite()))).canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}

