/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.util.LootUtil;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockCommonPlant;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.interfaces.SurvivesOnNetherGround;
import org.betterx.betternether.registry.NetherEntities;

public class BlockEggPlant
extends BlockCommonPlant
implements SurvivesOnNetherGround,
BehaviourPlant {
    private static final VoxelShape SHAPE = BlockEggPlant.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty DESTRUCTED = BNBlockProperties.DESTRUCTED;
    private boolean enableModDamage = true;
    private boolean enablePlayerDamage = true;

    public BlockEggPlant() {
        super(MapColor.TERRACOTTA_WHITE);
        this.enableModDamage = (Boolean)Configs.GAME_RULES.eggPlantMobDamage.get();
        this.enablePlayerDamage = (Boolean)Configs.GAME_RULES.eggPlantPlayerDamage.get();
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DESTRUCTED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{DESTRUCTED});
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.canSurviveOnTop(world, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)DESTRUCTED)).booleanValue()) {
            world.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 0.4, (double)pos.getZ() + random.nextDouble(), 0.46, 0.28, 0.55);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!((Boolean)state.getValue((Property)DESTRUCTED)).booleanValue()) {
            if (this.enableModDamage && entity instanceof LivingEntity && !((LivingEntity)entity).hasEffect(MobEffects.POISON)) {
                if (!NetherEntities.isNetherEntity(entity)) {
                    ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.POISON, 100, 3));
                }
            } else if (this.enablePlayerDamage && entity instanceof Player && !((Player)entity).hasEffect(MobEffects.POISON)) {
                ((Player)entity).addEffect(new MobEffectInstance(MobEffects.POISON, 100, 3));
            }
            double px = (double)pos.getX() + 0.5;
            double py = (double)pos.getY() + 0.125;
            double pz = (double)pos.getZ() + 0.5;
            if (world.isClientSide) {
                world.playLocalSound(px, py, pz, SoundType.WART_BLOCK.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                BlockParticleOption effect = new BlockParticleOption(ParticleTypes.BLOCK, state);
                RandomSource random = world.random;
                for (int i = 0; i < 24; ++i) {
                    world.addParticle((ParticleOptions)effect, px + random.nextGaussian() * 0.2, py + random.nextGaussian() * 0.2, pz + random.nextGaussian() * 0.2, random.nextGaussian(), random.nextGaussian(), random.nextGaussian());
                }
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DESTRUCTED, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.getParameter(LootContextParams.TOOL);
        if (LootUtil.isCorrectTool((ItemLike)this, (BlockState)state, (ItemStack)tool)) {
            return Collections.singletonList(new ItemStack((ItemLike)this.asItem()));
        }
        return super.getDrops(state, builder);
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)DESTRUCTED)).booleanValue()) {
            world.setBlockAndUpdate(pos, this.defaultBlockState());
        }
    }
}

