/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.betternether.blocks.BlockBase;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockEyeBase
extends BlockBase
implements AddMineableHoe {
    public BlockEyeBase(BlockBehaviour.Properties settings) {
        super(settings);
        this.setDropItself(false);
    }

    public boolean allowsSpawning(BlockState state, BlockGetter view, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockPos blockPos = pos.above();
        Block up = world.getBlockState(blockPos).getBlock();
        if (up != NetherBlocks.EYE_VINE && up != Blocks.NETHERRACK) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NetherBlocks.EYE_SEED);
    }
}

