/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;

public abstract class BlockFireBowl
extends BlockBaseNotFull {
    private static final VoxelShape SHAPE = BlockFireBowl.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CULL_SHAPE = Shapes.or((VoxelShape)BlockFireBowl.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BlockFireBowl.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), BlockFireBowl.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), BlockFireBowl.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), BlockFireBowl.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0)});
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    protected BlockFireBowl(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noOcclusion().lightLevel(BlockFireBowl::getLuminance));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected static int getLuminance(BlockState state) {
        return state.getOptionalValue((Property)LIT).orElse(false) != false ? 15 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{LIT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public VoxelShape getOcclusionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return CULL_SHAPE;
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.getDirection() == Direction.UP) {
            if (player.getMainHandItem().getItem() == Items.FLINT_AND_STEEL && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                if (!player.isCreative() && world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    player.getMainHandItem().hurtAndBreak(1, serverLevel, (ServerPlayer)player, item -> {});
                }
                world.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.4f + 0.8f);
                return ItemInteractionResult.SUCCESS;
            }
            if (player.getMainHandItem().isEmpty() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                world.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, world.random.nextFloat() * 0.4f + 0.8f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.fireImmune() && entity instanceof LivingEntity && ((Boolean)level.getBlockState(pos).getValue((Property)LIT)).booleanValue()) {
            entity.hurt(level.damageSources().hotFloor(), 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (random.nextInt(24) == 0) {
                world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
            if (random.nextInt(4) == 0) {
                world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 0.75, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static BlockFireBowl from(Block source) {
        return (BlockFireBowl)BehaviourHelper.from((Block)source, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BlockFireBowl
    implements BehaviourMetal {
        public Metal(Block source) {
            super(source);
        }
    }

    public static class Stone
    extends BlockFireBowl
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }
    }

    public static class Wood
    extends BlockFireBowl
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }
    }
}

