/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.interfaces.SurvivesOnGravel;
import org.betterx.wover.block.api.BlockProperties;

public class BlockNetherCactus
extends BlockBaseNotFull
implements SurvivesOnGravel,
BehaviourPlant {
    private static final VoxelShape TOP_SHAPE = BlockNetherCactus.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape SIDE_SHAPE = BlockNetherCactus.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final BooleanProperty TOP = BlockProperties.TOP;

    public BlockNetherCactus() {
        super(BehaviourBuilders.createCactus((MapColor)MapColor.TERRACOTTA_ORANGE, (boolean)false));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{TOP});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.getValue((Property)TOP) != false ? TOP_SHAPE : SIDE_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            Block up = world.getBlockState(pos.above()).getBlock();
            if (up == this) {
                return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(false));
            }
            return this.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState down = world.getBlockState(pos.below());
        return this.isSurvivable(down) || down.getBlock() == this;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
            return;
        }
        if (((Boolean)state.getValue((Property)TOP)).booleanValue() && random.nextInt(16) == 0) {
            BlockPos up = pos.above();
            boolean grow = world.getBlockState(up).getBlock() == Blocks.AIR;
            boolean bl = grow = grow && BlocksHelper.getLengthDown(world, pos, this) < 3;
            if (grow) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, up, this.defaultBlockState());
                BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        entity.hurt(world.damageSources().cactus(), 1.0f);
    }
}

