/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.api.v3.bonemeal.BonemealAPI;
import org.betterx.bclib.api.v3.bonemeal.BonemealNyliumLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.betternether.blocks.BlockBase;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockNetherMycelium
extends BlockBase
implements BonemealNyliumLike,
BehaviourStone,
BlockLootProvider {
    public static final BooleanProperty IS_BLUE = BooleanProperty.create((String)"blue");
    private BonemealAPI.FeatureProvider vegetationFeature;

    public BlockNetherMycelium() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERRACK).mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IS_BLUE, (Comparable)Boolean.valueOf(false)));
        this.setDropItself(false);
    }

    public void setVegetationFeature(BonemealAPI.FeatureProvider vegetationFeature) {
        this.vegetationFeature = vegetationFeature;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{IS_BLUE});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        world.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 1.1, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
    }

    public boolean isValidBonemealTarget(LevelReader blockGetter, BlockPos blockPos, BlockState blockState) {
        return this.vegetationFeature != null && super.isValidBonemealTarget(blockGetter, blockPos, blockState);
    }

    public Block getHostBlock() {
        return this;
    }

    @Nullable
    public Holder<? extends ConfiguredFeature<?, ?>> getCoverFeature() {
        return this.vegetationFeature.getFeature();
    }

    @Nullable
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return provider.dropWithSilkTouch((Block)this, (ItemLike)Blocks.NETHERRACK, (NumberProvider)ConstantValue.exactly((float)1.0f));
    }
}

