/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.bclib.interfaces.tools.AddMineableSword;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBase;
import org.betterx.betternether.blocks.materials.Materials;

public class BlockNetherReed
extends BlockBase
implements AddMineableSword,
AddMineableHoe {
    public static final BooleanProperty TOP = BlockProperties.TOP;

    public BlockNetherReed() {
        super(Materials.NETHER_PLANT.mapColor(MapColor.COLOR_CYAN).randomTicks());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{TOP});
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Block up = world.getBlockState(pos.above()).getBlock();
        BlockState down = world.getBlockState(pos.below());
        if (BlocksHelper.isNetherGround(down)) {
            BlockPos posDown = pos.below();
            boolean lava = org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(posDown.north()));
            lava = lava || org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(posDown.south()));
            lava = lava || org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(posDown.east()));
            boolean bl = lava = lava || org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(posDown.west()));
            if (lava) {
                return up == this ? (BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(false)) : this.defaultBlockState();
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (down.getBlock() != this) {
            return Blocks.AIR.defaultBlockState();
        }
        if (up != this) {
            return this.defaultBlockState();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(false));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos posDown = pos.below();
        BlockState down = world.getBlockState(posDown);
        if (BlocksHelper.isNetherGround(down)) {
            boolean lava = org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(posDown.north()));
            lava = lava || org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(posDown.south()));
            lava = lava || org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(posDown.east()));
            lava = lava || org.betterx.bclib.util.BlocksHelper.isLava((BlockState)world.getBlockState(posDown.west()));
            return lava;
        }
        return down.getBlock() == this;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos up;
        boolean grow;
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
            return;
        }
        if (((Boolean)state.getValue((Property)TOP)).booleanValue() && (grow = world.isEmptyBlock(up = pos.above()))) {
            int length = BlocksHelper.getLengthDown(world, pos, this);
            boolean isFertile = BlocksHelper.isFertile(world.getBlockState(pos.below(length)));
            if (isFertile) {
                length -= 2;
            }
            boolean bl = length < 3 && (isFertile ? random.nextInt(8) == 0 : random.nextInt(16) == 0) ? true : (grow = false);
            if (grow) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, up, this.defaultBlockState());
                BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
            }
        }
    }
}

