/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNLeaves;

public class BlockNetherSakuraLeaves
extends BNLeaves {
    private static final int COLOR = MHelper.color(251, 113, 143);

    public BlockNetherSakuraLeaves(Block sapling) {
        super(sapling, BehaviourBuilders.createStaticLeaves((MapColor)MapColor.COLOR_PINK, (boolean)false).noOcclusion().lightLevel(state -> 13));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter view, BlockPos pos) {
        return super.getShadeBrightness(state, view, pos) * 0.5f + 0.5f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter view, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockPos blockPos;
        if (random.nextInt(10) == 0 && world.isEmptyBlock(blockPos = pos.below())) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() - 0.05;
            double z = (double)pos.getZ() + random.nextDouble();
            world.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor(BlockState state, BlockGetter world, BlockPos pos) {
        return COLOR;
    }
}

