/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBNPot;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockPottedPlant
extends BlockBaseNotFull
implements AddMineableHoe {
    public static final EnumProperty<BNBlockProperties.PottedPlantShape> PLANT = BNBlockProperties.PLANT;

    public BlockPottedPlant() {
        super(Materials.NETHER_PLANT.mapColor(MapColor.COLOR_BLACK).lightLevel(BlockPottedPlant::getLuminance).offsetType(BlockBehaviour.OffsetType.NONE));
        this.setDropItself(false);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(PLANT, (Comparable)((Object)BNBlockProperties.PottedPlantShape.AGAVE)));
    }

    private static int getLuminance(BlockState blockState) {
        if (!blockState.hasProperty(PLANT)) {
            return 0;
        }
        if (blockState.getValue(PLANT) == BNBlockProperties.PottedPlantShape.WILLOW) {
            return 12;
        }
        if (blockState.getValue(PLANT) == BNBlockProperties.PottedPlantShape.JELLYFISH_MUSHROOM) {
            return 13;
        }
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Block block = ((BNBlockProperties.PottedPlantShape)((Object)state.getValue(PLANT))).getBlock();
        BlockState plantState = block.defaultBlockState();
        Vec3 vec3d = plantState.getOffset(view, pos);
        return plantState.getShape(view, pos, ePos).move(-vec3d.x, -0.5 - vec3d.y, -vec3d.z);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{PLANT});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).getBlock() instanceof BlockBNPot;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        Block block = ((BNBlockProperties.PottedPlantShape)((Object)state.getValue(PLANT))).getBlock();
        return Collections.singletonList(new ItemStack((ItemLike)block.asItem()));
    }

    public static BlockState getPlant(Item item) {
        for (BNBlockProperties.PottedPlantShape shape : BNBlockProperties.PottedPlantShape.values()) {
            if (!shape.getItem().equals(item)) continue;
            return (BlockState)NetherBlocks.POTTED_PLANT.defaultBlockState().setValue(PLANT, (Comparable)((Object)shape));
        }
        return null;
    }
}

