/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnNetherGround;
import org.betterx.wover.block.api.BlockProperties;

public class BlockSmoker
extends BlockBaseNotFull
implements SurvivesOnNetherGround,
AddMineableAxe {
    private static final VoxelShape TOP_SHAPE = BlockSmoker.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockSmoker.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public BlockSmoker() {
        super(Materials.makeNetherWood(MapColor.COLOR_BROWN));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (world.isEmptyBlock(pos.above())) {
            world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.getValue(SHAPE) == BlockProperties.TripleShape.TOP ? TOP_SHAPE : MIDDLE_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        Block side = world.getBlockState(pos.above()).getBlock();
        if (side != this) {
            return (BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP);
        }
        side = world.getBlockState(pos.below()).getBlock();
        if (side == this) {
            return (BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE);
        }
        return (BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockState down = world.getBlockState(pos.below());
        return down.getBlock() == this || this.isSurvivable(down);
    }
}

