/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnSoulGround;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.SoulLilyFeature;

public class BlockSoulLily
extends BlockBaseNotFull
implements SurvivesOnSoulGround,
AddMineableAxe {
    public static final EnumProperty<SoulLilyShape> SHAPE = EnumProperty.create((String)"shape", SoulLilyShape.class);
    private static final VoxelShape SHAPE_SMALL = BlockSoulLily.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_MEDIUM_BOTTOM = BlockSoulLily.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_MEDIUM_TOP = BlockSoulLily.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_BOTTOM = BlockSoulLily.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_BIG_MIDDLE = BlockSoulLily.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_BIG_TOP_CENTER = BlockSoulLily.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_N = BlockSoulLily.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_S = BlockSoulLily.box((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_E = BlockSoulLily.box((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final VoxelShape SHAPE_BIG_TOP_SIDE_W = BlockSoulLily.box((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0);
    private static final SoulLilyFeature STRUCTURE = new SoulLilyFeature();
    private static final SoulLilyShape[] ROT = new SoulLilyShape[]{SoulLilyShape.BIG_TOP_SIDE_N, SoulLilyShape.BIG_TOP_SIDE_E, SoulLilyShape.BIG_TOP_SIDE_S, SoulLilyShape.BIG_TOP_SIDE_W};

    public BlockSoulLily() {
        super(Materials.makeNetherWood(MapColor.COLOR_ORANGE).strength(1.0f).noOcclusion().randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(SHAPE, (Comparable)((Object)SoulLilyShape.SMALL)));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        switch (((SoulLilyShape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 3: {
                return SHAPE_BIG_BOTTOM;
            }
            case 4: {
                return SHAPE_BIG_MIDDLE;
            }
            case 5: {
                return SHAPE_BIG_TOP_CENTER;
            }
            case 1: {
                return SHAPE_MEDIUM_BOTTOM;
            }
            case 2: {
                return SHAPE_MEDIUM_TOP;
            }
            case 6: {
                return SHAPE_BIG_TOP_SIDE_N;
            }
            case 7: {
                return SHAPE_BIG_TOP_SIDE_S;
            }
            case 8: {
                return SHAPE_BIG_TOP_SIDE_E;
            }
            case 9: {
                return SHAPE_BIG_TOP_SIDE_W;
            }
        }
        return SHAPE_SMALL;
    }

    public boolean canGrow(Level world, BlockPos pos, RandomSource random) {
        BlockState state = world.getBlockState(pos.below());
        if (state.getBlock() == this || state.getBlock() == Blocks.SOUL_SAND || BlocksHelper.isFertile(world.getBlockState(pos.below()))) {
            return BlocksHelper.isFertile(world.getBlockState(pos.below())) ? random.nextInt(8) == 0 : random.nextInt(16) == 0;
        }
        return false;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (this.canGrow((Level)world, pos, random)) {
            SoulLilyShape shape = (SoulLilyShape)((Object)state.getValue(SHAPE));
            if (shape == SoulLilyShape.SMALL && world.isEmptyBlock(pos.above())) {
                STRUCTURE.growMedium((LevelAccessor)world, pos);
            } else if (shape == SoulLilyShape.MEDIUM_BOTTOM && world.isEmptyBlock(pos.above(2)) && this.isAirSides((Level)world, pos.above(2))) {
                STRUCTURE.growBig((LevelAccessor)world, pos);
            }
        }
    }

    private boolean isAirSides(Level world, BlockPos pos) {
        return world.isEmptyBlock(pos.north()) && world.isEmptyBlock(pos.south()) && world.isEmptyBlock(pos.east()) && world.isEmptyBlock(pos.west());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.getValue(SHAPE));
        int index = this.getRotationIndex(shape);
        if (index < 0) {
            return state;
        }
        int offset = this.rotOffset(rotation);
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)ROT[index + offset & 3]));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.getValue(SHAPE));
        int index = this.getRotationIndex(shape);
        if (index < 0) {
            return state;
        }
        if (mirror == Mirror.FRONT_BACK) {
            if (shape == SoulLilyShape.BIG_TOP_SIDE_E) {
                shape = SoulLilyShape.BIG_TOP_SIDE_W;
            } else if (shape == SoulLilyShape.BIG_TOP_SIDE_W) {
                shape = SoulLilyShape.BIG_TOP_SIDE_E;
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (shape == SoulLilyShape.BIG_TOP_SIDE_N) {
                shape = SoulLilyShape.BIG_TOP_SIDE_S;
            } else if (shape == SoulLilyShape.BIG_TOP_SIDE_S) {
                shape = SoulLilyShape.BIG_TOP_SIDE_N;
            }
        }
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)shape));
    }

    private int getRotationIndex(SoulLilyShape shape) {
        for (int i = 0; i < 4; ++i) {
            if (shape != ROT[i]) continue;
            return i;
        }
        return -1;
    }

    private int rotOffset(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return 0;
        }
        if (rotation == Rotation.CLOCKWISE_90) {
            return 1;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 3;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NetherBlocks.SOUL_LILY_SAPLING);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Comparable _shape = (Comparable)state.getValues().get(SHAPE);
        if (_shape == null) {
            return false;
        }
        SoulLilyShape shape = (SoulLilyShape)((Object)SHAPE.getValueClass().cast(_shape));
        if (shape == SoulLilyShape.BIG_TOP_SIDE_N) {
            return world.getBlockState(pos.north()).getBlock() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_S) {
            return world.getBlockState(pos.south()).getBlock() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_E) {
            return world.getBlockState(pos.east()).getBlock() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_W) {
            return world.getBlockState(pos.west()).getBlock() == this;
        }
        BlockState down = world.getBlockState(pos.below());
        return down.getBlock() == this || this.isSurvivable(down);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.canSurvive(state, (LevelReader)world, pos) ? state : Blocks.AIR.defaultBlockState();
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        switch (((SoulLilyShape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 3: 
            case 4: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem())});
            }
            case 5: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new ItemStack((ItemLike)NetherBlocks.SOUL_LILY_SAPLING)});
            }
            case 1: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem())});
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new ItemStack((ItemLike)NetherBlocks.SOUL_LILY_SAPLING, MHelper.randRange(0, 1, MHelper.RANDOM))});
            }
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new ItemStack((ItemLike)NetherBlocks.SOUL_LILY_SAPLING)});
    }

    public static enum SoulLilyShape implements StringRepresentable
    {
        SMALL("small"),
        MEDIUM_BOTTOM("medium_bottom"),
        MEDIUM_TOP("medium_top"),
        BIG_BOTTOM("big_bottom"),
        BIG_MIDDLE("big_middle"),
        BIG_TOP_CENTER("big_top_center"),
        BIG_TOP_SIDE_N("big_top_side_n"),
        BIG_TOP_SIDE_S("big_top_side_s"),
        BIG_TOP_SIDE_E("big_top_side_e"),
        BIG_TOP_SIDE_W("big_top_side_w");

        final String name;

        private SoulLilyShape(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

