/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.blocks.BlockBaseNotFull;

public class BlockStalactite
extends BlockBaseNotFull
implements BehaviourStone {
    public static final IntegerProperty SIZE = BlockProperties.SIZE;
    private static final VoxelShape[] SHAPES = new VoxelShape[8];

    public BlockStalactite(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SIZE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SIZE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPES[(Integer)state.getValue((Property)SIZE)];
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockState state2;
        int size;
        int i;
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        if (world.getBlockState(pos.below()).getBlock() instanceof BlockStalactite) {
            POS.setX(pos.getX());
            POS.setZ(pos.getZ());
            for (i = 1; i < 8; ++i) {
                POS.setY(pos.getY() - i);
                if (!(world.getBlockState((BlockPos)POS).getBlock() instanceof BlockStalactite) || (size = ((Integer)(state2 = world.getBlockState((BlockPos)POS)).getValue((Property)SIZE)).intValue()) >= i) break;
                world.setBlockAndUpdate((BlockPos)POS, (BlockState)state2.setValue((Property)SIZE, (Comparable)Integer.valueOf(i)));
            }
        }
        if (world.getBlockState(pos.above()).getBlock() instanceof BlockStalactite) {
            POS.setX(pos.getX());
            POS.setZ(pos.getZ());
            for (i = 1; i < 8; ++i) {
                POS.setY(pos.getY() + i);
                if (!(world.getBlockState((BlockPos)POS).getBlock() instanceof BlockStalactite) || (size = ((Integer)(state2 = world.getBlockState((BlockPos)POS)).getValue((Property)SIZE)).intValue()) >= i) break;
                world.setBlockAndUpdate((BlockPos)POS, (BlockState)state2.setValue((Property)SIZE, (Comparable)Integer.valueOf(i)));
            }
        }
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockPos pos2 = pos.above();
        BlockState state2 = world.getBlockState(pos2);
        if (state2.getBlock() instanceof BlockStalactite && (Integer)state2.getValue((Property)SIZE) < (Integer)state.getValue((Property)SIZE)) {
            state2.getBlock().destroy(world, pos2, state2);
            world.destroyBlock(pos2, true);
        }
        if ((state2 = world.getBlockState(pos2 = pos.below())).getBlock() instanceof BlockStalactite && (Integer)state2.getValue((Property)SIZE) < (Integer)state.getValue((Property)SIZE)) {
            state2.getBlock().destroy(world, pos2, state2);
            world.destroyBlock(pos2, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.canPlace(world, pos, Direction.UP) || this.canPlace(world, pos, Direction.DOWN);
    }

    private boolean canPlace(LevelReader world, BlockPos pos, Direction dir) {
        return world.getBlockState(pos.relative(dir)).getBlock() instanceof BlockStalactite || BlockStalactite.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(dir), (Direction)dir.getOpposite());
    }

    static {
        for (int i = 0; i < 8; ++i) {
            BlockStalactite.SHAPES[i] = BlockStalactite.box((double)(7 - i), (double)0.0, (double)(7 - i), (double)(9 + i), (double)16.0, (double)(9 + i));
        }
    }
}

