/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;

public class BlockStalagnateBowl
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape SHAPE = BlockStalagnateBowl.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    public static final EnumProperty<BNBlockProperties.FoodShape> FOOD = BNBlockProperties.FOOD;

    public BlockStalagnateBowl(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noOcclusion());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FOOD, (Comparable)((Object)BNBlockProperties.FoodShape.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FOOD});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)((BNBlockProperties.FoodShape)((Object)state.getValue(FOOD))).getItem()));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos down = pos.below();
        return world.getBlockState(down).isFaceSturdy((BlockGetter)world, down, Direction.UP);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }
}

