/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourSapling;
import org.betterx.bclib.blocks.FeatureSaplingBlock;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.interfaces.SurvivesOnNetherrack;
import org.betterx.betternether.registry.features.configured.NetherTrees;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.configurators.AsPillar;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;

public class BlockStalagnateSeed
extends FeatureSaplingBlock
implements BonemealableBlock,
SurvivesOnNetherrack,
BehaviourSapling {
    public static final int MAX_SEARCH_LENGTH = 25;
    public static final int MIN_LENGTH = 3;
    protected static final VoxelShape SHAPE_TOP = Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BOTTOM = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");

    public BlockStalagnateSeed() {
        super((level, pos, state, rnd) -> BlockStalagnateSeed.growsDownward(state) ? NetherTrees.STALAGNATE_DOWN.placeInWorld(WorldState.registryAccess(), (WorldGenLevel)level, pos, rnd) : NetherTrees.STALAGNATE.placeInWorld(WorldState.registryAccess(), (WorldGenLevel)level, pos, rnd));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{TOP});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = this.defaultBlockState();
        if (ctx.getClickedFace() == Direction.DOWN) {
            return blockState;
        }
        if (ctx.getClickedFace() == Direction.UP) {
            return (BlockState)blockState.setValue((Property)TOP, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BlockStalagnateSeed.growsDownward(state) ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    private static boolean growsDownward(BlockState state) {
        return (Boolean)state.getValue((Property)TOP);
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        if (super.isBonemealSuccess(world, random, pos, state)) {
            if (BlockStalagnateSeed.growsDownward(state)) {
                return BlocksHelper.downRay((LevelAccessor)world, pos, 3) > 0;
            }
            return BlocksHelper.upRay((LevelAccessor)world, pos, 3) > 0;
        }
        return false;
    }

    protected boolean mayPlaceOn(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.isSurvivable(blockState);
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        if (blockState.getValues().get(TOP) == null) {
            return false;
        }
        BlockPos target = BlockStalagnateSeed.growsDownward(blockState) ? blockPos.above() : blockPos.below();
        return this.mayPlaceOn(levelReader.getBlockState(target), (BlockGetter)levelReader, target);
    }

    protected boolean growFeature(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull RandomSource random) {
        if (WorldState.registryAccess() == null) {
            return false;
        }
        ConfiguredFeatureKey<AsPillar> featureHolder = BlockStalagnateSeed.growsDownward(state) ? NetherTrees.STALAGNATE_DOWN : NetherTrees.STALAGNATE;
        return featureHolder.placeInWorld(WorldState.registryAccess(), (WorldGenLevel)world, pos, random);
    }
}

