/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockWillowBranch
extends BlockBaseNotFull
implements AddMineableAxe {
    private static final VoxelShape V_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<BNBlockProperties.WillowBranchShape> SHAPE = BNBlockProperties.WILLOW_SHAPE;

    public BlockWillowBranch() {
        super(Materials.makeNetherWood(MapColor.TERRACOTTA_RED).noOcclusion().noCollission().lightLevel(BlockWillowBranch::getLuminance));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.MIDDLE)));
    }

    protected static int getLuminance(BlockState state) {
        return state.getOptionalValue(SHAPE).map(s -> s == BNBlockProperties.WillowBranchShape.END ? 15 : 0).orElse(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return V_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (world.isEmptyBlock(pos.above())) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)(state.getValue(SHAPE) == BNBlockProperties.WillowBranchShape.END ? NetherBlocks.MAT_WILLOW.getTorch() : NetherBlocks.WILLOW_LEAVES));
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.getValue(SHAPE) == BNBlockProperties.WillowBranchShape.END) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)NetherBlocks.MAT_WILLOW.getTorch())});
        }
        return Lists.newArrayList();
    }
}

