/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks.complex;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.entry.SlotMap;
import org.betterx.bclib.complexmaterials.set.wood.Planks;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.bclib.items.boat.BoatTypeOverride;
import org.betterx.betternether.blocks.complex.NetherWoodenMaterial;
import org.betterx.betternether.blocks.complex.slots.NetherSlots;
import org.betterx.betternether.blocks.complex.slots.Stem;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.jetbrains.annotations.Nullable;

public class NetherMushroomMaterial
extends NetherWoodenMaterial<NetherMushroomMaterial> {
    public NetherMushroomMaterial() {
        super("nether_mushroom", MapColor.TERRACOTTA_WHITE, MapColor.COLOR_LIGHT_GRAY);
        this.setFurnitureCloth(Blocks.RED_WOOL);
    }

    @Override
    protected SlotMap<WoodenComplexMaterial> createMaterialSlots() {
        return super.createMaterialSlots().remove(WoodSlots.LOG).remove(WoodSlots.BARK).remove(WoodSlots.STRIPPED_LOG).remove(WoodSlots.STRIPPED_BARK).add((MaterialSlot)new Stem(this){

            @Override
            @Nullable
            protected void makeRecipe(RecipeOutput context, ComplexMaterial material, ResourceLocation id) {
            }
        }).replace((MaterialSlot)new Planks(this){

            @Nullable
            protected void makeRecipe(RecipeOutput context, ComplexMaterial material, ResourceLocation id) {
                CraftingRecipeBuilder craftingRecipeBuilder1 = RecipeBuilder.crafting((ResourceLocation)id, (ItemLike)material.getBlock(WoodSlots.PLANKS));
                CraftingRecipeBuilder craftingRecipeBuilder = craftingRecipeBuilder1.outputCount(4).shapeless().addMaterial('#', new ItemLike[]{material.getBlock(NetherSlots.STEM)});
                CraftingRecipeBuilder craftingRecipeBuilderBaseRecipeBuilder = craftingRecipeBuilder.group("planks");
                ((CraftingRecipeBuilder)craftingRecipeBuilderBaseRecipeBuilder.category(RecipeCategory.BUILDING_BLOCKS)).build(context);
            }
        });
    }

    @Nullable
    public <M extends ComplexMaterial> Block getBlock(MaterialSlot<M> key) {
        if (key.suffix.equals(WoodSlots.STRIPPED_LOG.suffix)) {
            return this.getStem();
        }
        return super.getBlock(key);
    }

    public Block getStem() {
        return this.getBlock(NetherSlots.STEM);
    }

    public BoatTypeOverride supplyBoatType() {
        return super.supplyBoatType();
    }
}

