/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.commands.PlaceCommand;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class CommandRegistry {
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> Component.literal((String)("The next biome (" + String.valueOf(object) + ") was not found.")));
    private static final int MAX_SEARCH_RADIUS = 12800;
    private static final int SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int SAMPLE_RESOLUTION_VERTICAL = 64;
    private static int biomeIndex = 0;
    private static int placeMapIdx = 0;
    private static final BlockState[] states = new BlockState[]{Blocks.RED_STAINED_GLASS.defaultBlockState(), Blocks.BLUE_STAINED_GLASS.defaultBlockState(), Blocks.YELLOW_STAINED_GLASS.defaultBlockState(), Blocks.LIME_STAINED_GLASS.defaultBlockState(), Blocks.PINK_STAINED_GLASS.defaultBlockState(), Blocks.GREEN_STAINED_GLASS.defaultBlockState(), Blocks.WHITE_STAINED_GLASS.defaultBlockState(), Blocks.BLACK_STAINED_GLASS.defaultBlockState(), Blocks.ORANGE_STAINED_GLASS.defaultBlockState(), Blocks.LIGHT_BLUE_STAINED_GLASS.defaultBlockState()};
    private static final BlockState[] states2 = new BlockState[]{Blocks.RED_CONCRETE.defaultBlockState(), Blocks.BLUE_CONCRETE.defaultBlockState(), Blocks.YELLOW_CONCRETE.defaultBlockState(), Blocks.LIME_CONCRETE.defaultBlockState(), Blocks.PINK_CONCRETE.defaultBlockState(), Blocks.GREEN_CONCRETE.defaultBlockState(), Blocks.WHITE_CONCRETE.defaultBlockState(), Blocks.BLACK_CONCRETE.defaultBlockState(), Blocks.ORANGE_CONCRETE.defaultBlockState(), Blocks.LIGHT_BLUE_CONCRETE.defaultBlockState()};
    public static final PerlinSimplexNoise BIOME_INFO_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(2345L)), (List)ImmutableList.of((Object)0));

    public static void register() {
        NeoForge.EVENT_BUS.addListener(CommandRegistry::onRegisterCommands);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandRegistry.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        LiteralArgumentBuilder<CommandSourceStack> bnContext = (LiteralArgumentBuilder<CommandSourceStack>)Commands.literal((String)"bn").requires(source -> source.hasPermission(4));
        bnContext = PlaceCommand.register(bnContext);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)Commands.literal((String)"test_place").requires(source -> source.hasPermission(4))).executes(ctx -> CommandRegistry.testPlace((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.literal((String)"find_surface").requires(source -> source.hasPermission(4))).executes(ctx -> CommandRegistry.findSurface((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.literal((String)"tpnext").requires(source -> source.hasPermission(4))).executes(ctx -> CommandRegistry.teleportToNextBiome((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.literal((String)"place_all").requires(source -> source.hasPermission(4))).executes(ctx -> CommandRegistry.placeAllBlocks((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.literal((String)"place_matching").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandRegistry.placeMatchingBlocks((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"type"))))));
    }

    private static int teleportToNextBiome(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos target;
        BlockState state;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        HolderLookup.RegistryLookup biomeLookup = WorldState.registryAccess().lookupOrThrow(Registries.BIOME);
        List<ResourceKey> biomes = ((HolderSet.Named)biomeLookup.get(NetherTags.BETTER_NETHER).orElseThrow()).stream().map(Holder::unwrapKey).filter(Optional::isPresent).map(Optional::get).toList();
        if (biomeIndex < 0 || biomeIndex >= biomes.size()) {
            source.sendFailure((Component)Component.literal((String)"Failed to find the next Biome...").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
            return 0;
        }
        final ResourceKey biome = biomes.get(biomeIndex);
        source.sendSuccess(() -> Component.literal((String)("Locating Biome " + String.valueOf(biome))).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN)), false);
        biomeIndex = (biomeIndex + 1) % biomes.size();
        BlockPos currentPosition = new BlockPos((int)source.getPosition().x, (int)source.getPosition().y, (int)source.getPosition().z);
        BlockPos biomePosition = (BlockPos)source.getLevel().findClosestBiome3d(b -> ((ResourceKey)b.unwrapKey().orElseThrow()).location().equals((Object)biome.location()), currentPosition, 12800, 32, 64).getFirst();
        final String biomeName = biome.toString();
        if (biomePosition == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)biomeName);
        }
        ServerPlayer player = source.getPlayerOrException();
        double yPos = source.getPosition().y();
        boolean didWrap = false;
        do {
            target = new BlockPos(biomePosition.getX(), (int)yPos, biomePosition.getZ());
            state = player.level().getBlockState(target);
            if (!((yPos -= 1.0) <= (double)(player.level().getMinBuildHeight() + 1))) continue;
            if (didWrap) break;
            yPos = 127.0;
            didWrap = true;
        } while (!state.isAir() && yPos > (double)player.level().getMinBuildHeight() && yPos < (double)player.level().getMaxBuildHeight());
        Vector3d targetPlayerPos = new Vector3d((double)target.getX() + 0.5, (double)(target.getY() - 1), (double)target.getZ() + 0.5);
        player.connection.teleport(targetPlayerPos.x, targetPlayerPos.y, targetPlayerPos.z, 0.0f, 0.0f, Collections.EMPTY_SET);
        ResourceOrTagKeyArgument.Result result = new ResourceOrTagKeyArgument.Result(){

            public Either<ResourceKey, TagKey> unwrap() {
                return Either.left((Object)biome);
            }

            public Optional<ResourceOrTagKeyArgument.Result> cast(ResourceKey resourceKey) {
                return Optional.empty();
            }

            public String asPrintable() {
                return biomeName;
            }

            public boolean test(Object o) {
                return false;
            }
        };
        ResourceKey a = biome;
        if (WorldState.allStageRegistryAccess() != null) {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
            Holder h = (Holder)WorldState.allStageRegistryAccess().registryOrThrow(Registries.BIOME).getHolder(a).orElseThrow();
            stopwatch.stop();
            return LocateCommand.showLocateResult((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)result, (BlockPos)currentPosition, (Pair)new Pair((Object)biomePosition, (Object)h), (String)"commands.locatebiome.success", (boolean)false, (Duration)stopwatch.elapsed());
        }
        return 1;
    }

    private static int placeMatchingBlocks(CommandContext<CommandSourceStack> ctx, String type) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Vec3 pos = source.getPosition();
        LinkedList<Block> blocks = new LinkedList<Block>();
        for (Block block : NetherBlocks.getModBlocks().sorted(CommandRegistry::compareBlockNames).collect(Collectors.toList())) {
            String name = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
            if (name.indexOf(type) < 0) continue;
            blocks.add(block);
        }
        CommandRegistry.placeBlockRow(player, pos, blocks, 1, true);
        return 1;
    }

    @NotNull
    private static int compareBlockNames(Block a, Block b) {
        String as = BuiltInRegistries.BLOCK.getKey((Object)a).getPath();
        String bs = BuiltInRegistries.BLOCK.getKey((Object)b).getPath();
        return as.compareTo(bs);
    }

    private static int findSurface(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Vec3 pos = source.getPosition();
        ServerLevel level = source.getLevel();
        BlockPos.MutableBlockPos mPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z).mutable();
        System.out.println("Staring at: " + String.valueOf(mPos) + " -> " + String.valueOf(level.getBlockState((BlockPos)mPos)));
        boolean found = org.betterx.bclib.util.BlocksHelper.findSurroundingSurface((LevelAccessor)level, (BlockPos.MutableBlockPos)mPos, (Direction)Direction.DOWN, (int)12, state -> BlocksHelper.isNetherGroundMagma(state));
        System.out.println("Ending at: " + String.valueOf(mPos) + " -> " + String.valueOf(level.getBlockState((BlockPos)mPos)) + " = " + found);
        org.betterx.bclib.util.BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), (Block)Blocks.YELLOW_CONCRETE);
        org.betterx.bclib.util.BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)mPos, (Block)Blocks.LIGHT_BLUE_CONCRETE);
        return 1;
    }

    private static int testPlace(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Vec3 pos = source.getPosition();
        ServerLevel level = source.getLevel();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                double v = BIOME_INFO_NOISE.getValue(((double)x + pos.x) / 200.0, ((double)y + pos.z) / 200.0, false);
                if (v < min) {
                    min = v;
                }
                if (!(v > max)) continue;
                max = v;
            }
        }
        System.out.println("Noise: " + min + " - " + max);
        Holder pHolder = NetherVegetationPlaced.VEGETATION_GRASSLANDS.getHolder(WorldState.registryAccess());
        if (pHolder == null) {
            return -1;
        }
        PlacedFeature pFeature = (PlacedFeature)pHolder.value();
        List placements = pFeature.placement();
        PlacementContext pctx = new PlacementContext((WorldGenLevel)level, level.getChunkSource().getGenerator(), Optional.of(pFeature));
        Stream<Object> s = Stream.of(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z));
        LegacyRandomSource rnd = new LegacyRandomSource(121212L);
        placeMapIdx = 0;
        LinkedList posStates = new LinkedList();
        for (PlacementModifier p2 : placements) {
            s = s.flatMap(arg_0 -> CommandRegistry.lambda$testPlace$15(p2, pctx, (RandomSource)rnd, arg_0));
            List<Object> list = s.toList();
            placeMapIdx = (placeMapIdx + 1) % states.length;
            BlockState state1 = states[placeMapIdx];
            System.out.println(p2.getClass().getSimpleName() + " -> " + list.size() + ", " + String.valueOf(state1));
            list.forEach(bp -> {
                BlockState state = states[placeMapIdx];
                if (org.betterx.bclib.util.BlocksHelper.isTerrain((BlockState)level.getBlockState(bp))) {
                    state = states2[placeMapIdx];
                }
                posStates.add(new Pair(bp, (Object)state));
            });
            s = list.stream();
        }
        posStates.forEach(p -> BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)p.getFirst(), (BlockState)p.getSecond()));
        return 1;
    }

    private static int placeAllBlocks(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Vec3 pos = source.getPosition();
        LinkedList<Block> pickaxes = new LinkedList<Block>();
        LinkedList<Block> axes = new LinkedList<Block>();
        LinkedList<Block> hoes = new LinkedList<Block>();
        LinkedList<Block> shovels = new LinkedList<Block>();
        LinkedList<Block> other = new LinkedList<Block>();
        for (Block block : NetherBlocks.getModBlocks().sorted(CommandRegistry::compareBlockNames).collect(Collectors.toList())) {
            BlockState state = block.defaultBlockState();
            if (state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
                pickaxes.add(block);
                continue;
            }
            if (state.is(BlockTags.MINEABLE_WITH_AXE)) {
                axes.add(block);
                continue;
            }
            if (state.is(BlockTags.MINEABLE_WITH_HOE)) {
                hoes.add(block);
                continue;
            }
            if (state.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
                shovels.add(block);
                continue;
            }
            other.add(block);
        }
        CommandRegistry.placeBlockRow(player, pos, pickaxes, 1, false);
        CommandRegistry.placeBlockRow(player, pos, axes, 2, false);
        CommandRegistry.placeBlockRow(player, pos, hoes, 3, false);
        CommandRegistry.placeBlockRow(player, pos, shovels, 4, false);
        CommandRegistry.placeBlockRow(player, pos, other, 5, false);
        return 1;
    }

    private static void placeBlockRow(ServerPlayer player, Vec3 pos, List<Block> blocklist, int offset, boolean square) {
        int i = 0;
        int j = 0;
        int rowLen = (int)Math.ceil(Math.sqrt(blocklist.size()));
        blocklist.sort((a, b) -> {
            if (a instanceof DoorBlock && !(b instanceof DoorBlock)) {
                return 1;
            }
            if (!(a instanceof DoorBlock) && b instanceof DoorBlock) {
                return -1;
            }
            return 0;
        });
        for (Block bl : blocklist) {
            BlockState state = bl.defaultBlockState();
            BlockPos blockPos = new BlockPos((int)pos.x + i, (int)pos.y + j, (int)pos.z + offset);
            CommandRegistry.place(player, bl, state, blockPos);
            if (++i < rowLen) continue;
            i = 0;
            ++j;
        }
    }

    private static void place(ServerPlayer player, Block bl, BlockState state, BlockPos blockPos) {
        if (bl instanceof LadderBlock) {
            // empty if block
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)player.level(), blockPos, state);
        if (bl instanceof DoorBlock) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)player.level(), blockPos.above(), (BlockState)state.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
    }

    private static /* synthetic */ Stream lambda$testPlace$15(PlacementModifier p, PlacementContext pctx, RandomSource rnd, BlockPos bp) {
        return p.getPositions(pctx, rnd, bp);
    }
}

