/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;

public class PlaceCommand {
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(object -> Component.translatable((String)"commands.locate.structure.invalid", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_NBT_STRUCTURE_NOT_FOUND = new DynamicCommandExceptionType(object -> Component.literal((String)("The nbt-structure (" + String.valueOf(object) + ") was not found.")));

    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext) {
        return (LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)Commands.literal((String)"place").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.literal((String)"structure").then(Commands.argument((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.STRUCTURE)).executes(commandContext -> PlaceCommand.placeStructure((CommandSourceStack)commandContext.getSource(), (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)commandContext, (String)"structure", (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)ERROR_STRUCTURE_INVALID))))));
    }

    public static int placeStructure(CommandSourceStack stack, ResourceOrTagKeyArgument.Result<Structure> result) throws CommandSyntaxException {
        Registry registry = stack.getLevel().registryAccess().registryOrThrow(Registries.STRUCTURE);
        HolderSet holderSet = (HolderSet)LocateCommand.getHolders(result, (Registry)registry).orElseThrow(() -> ERROR_STRUCTURE_INVALID.create((Object)result.asPrintable()));
        BlockPos blockPos = new BlockPos((int)stack.getPosition().x, (int)stack.getPosition().y, (int)stack.getPosition().z);
        ServerLevel serverLevel = stack.getLevel();
        if (holderSet.size() == 0) {
            throw ERROR_STRUCTURE_INVALID.create((Object)result.asPrintable());
        }
        Structure s = (Structure)holderSet.get(0).value();
        return 1;
    }
}

