/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.enchantments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherEnchantments;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class RubyFire {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final Map<Item, RecipeHolder<BlastingRecipe>> FIRE_CONVERSIONS = new HashMap<Item, RecipeHolder<BlastingRecipe>>();
    public static final ThreadLocal<List<ItemStack>> convertedDrops = ThreadLocal.withInitial(ArrayList::new);

    public static boolean getDrops(BlockState brokenBlock, ServerLevel level, BlockPos blockPos, Player player, ItemStack breakingItem) {
        Holder rubyFire = NetherEnchantments.RUBY_FIRE.getHolder(player.registryAccess());
        if (rubyFire == null) {
            return false;
        }
        int fireLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)rubyFire, (ItemStack)breakingItem);
        if (fireLevel > 0) {
            Holder.Reference silk = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH);
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)silk, (ItemStack)breakingItem) > 0) {
                return false;
            }
            if (FIRE_CONVERSIONS.isEmpty()) {
                RubyFire.buildConversionTable(level);
            }
            boolean didConvert = false;
            int xpDrop = 0;
            try {
                List drops = Block.getDrops((BlockState)brokenBlock, (ServerLevel)level, (BlockPos)blockPos, null, (Entity)player, (ItemStack)breakingItem);
                convertedDrops.get().clear();
                for (ItemStack stack : drops) {
                    BlastingRecipe result;
                    RecipeHolder<BlastingRecipe> resultHolder = FIRE_CONVERSIONS.get(stack.getItem());
                    BlastingRecipe blastingRecipe = result = resultHolder != null ? (BlastingRecipe)resultHolder.value() : null;
                    if (result != null) {
                        didConvert = true;
                        ItemStack resultStack = result.getResultItem((HolderLookup.Provider)level.registryAccess());
                        xpDrop = (int)((float)xpDrop + result.getExperience());
                        convertedDrops.get().add(new ItemStack((ItemLike)resultStack.getItem(), resultStack.getCount() * stack.getCount()));
                        continue;
                    }
                    convertedDrops.get().add(stack);
                }
            }
            catch (Exception e) {
                BetterNether.C.log.error("Unable to get Drops for " + String.valueOf(breakingItem), e);
            }
            if (didConvert) {
                if (xpDrop > 0) {
                    RubyFire.popExperience(level, blockPos, xpDrop);
                }
                convertedDrops.get().forEach(itemStack -> Block.popResource((Level)level, (BlockPos)blockPos, (ItemStack)itemStack));
                brokenBlock.spawnAfterBreak(level, blockPos, breakingItem, true);
                convertedDrops.get().clear();
                return true;
            }
            convertedDrops.get().clear();
        }
        return false;
    }

    private static void popExperience(ServerLevel level, BlockPos blockPos, int amount) {
        if (level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
            ExperienceOrb.award((ServerLevel)level, (Vec3)Vec3.atCenterOf((Vec3i)blockPos), (int)amount);
        }
    }

    private static void buildConversionTable(ServerLevel level) {
        List recipes = level.getRecipeManager().getAllRecipesFor(RecipeType.BLASTING);
        for (RecipeHolder r : recipes) {
            for (Ingredient ingredient : ((BlastingRecipe)r.value()).getIngredients()) {
                for (ItemStack stack : ingredient.getItems()) {
                    BlockItem blitem;
                    Item item = stack.getItem();
                    if (item instanceof BlockItem && (blitem = (BlockItem)item).getBlock().defaultBlockState().is(CommonBlockTags.IS_OBSIDIAN)) continue;
                    FIRE_CONVERSIONS.put(stack.getItem(), (RecipeHolder<BlastingRecipe>)r);
                }
            }
        }
    }
}

