/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherEntities;

public class EntityFlyingPig
extends DespawnableAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Byte> DATA_SHARED_FLAGS_ID = SynchedEntityData.defineId(EntityFlyingPig.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final int BIT_ROOSTING = 0;
    private static final int BIT_WARTED = 1;
    private Goal preGoal;

    public EntityFlyingPig(EntityType<? extends EntityFlyingPig> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.LAVA, 0.0f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.xpReward = 2;
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof Player ? this.getSpeed() * 0.1f : 0.3f;
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(2, (Goal)new FindFoodGoal());
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new SittingGoal());
        this.goalSelector.addGoal(5, (Goal)new RoostingGoal());
        this.goalSelector.addGoal(6, (Goal)new WanderAroundGoal());
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.FOLLOW_RANGE, 12.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FLYING_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 1.0);
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                return this.level.isEmptyBlock(pos);
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(true);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SHARED_FLAGS_ID, (Object)MHelper.setBit((byte)0, 1, this.random.nextInt(4) == 0));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("byteData", ((Byte)this.entityData.get(DATA_SHARED_FLAGS_ID)).byteValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("byteData")) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (Object)tag.getByte("byteData"));
        }
    }

    public boolean isRoosting() {
        byte b = (Byte)this.entityData.get(DATA_SHARED_FLAGS_ID);
        return MHelper.getBit(b, 0);
    }

    public void setRoosting(boolean roosting) {
        byte b = (Byte)this.entityData.get(DATA_SHARED_FLAGS_ID);
        this.entityData.set(DATA_SHARED_FLAGS_ID, (Object)MHelper.setBit(b, 0, roosting));
    }

    public boolean isWarted() {
        byte b = (Byte)this.entityData.get(DATA_SHARED_FLAGS_ID);
        return MHelper.getBit(b, 1);
    }

    public void setWarted(boolean warted) {
        byte b = (Byte)this.entityData.get(DATA_SHARED_FLAGS_ID);
        this.entityData.set(DATA_SHARED_FLAGS_ID, (Object)MHelper.setBit(b, 1, warted));
    }

    protected float getSoundVolume() {
        return MHelper.randRange(0.85f, 1.15f, this.random);
    }

    public float getVoicePitch() {
        return MHelper.randRange(0.3f, 0.4f, this.random);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.PIG_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PIG_DEATH;
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.PIG_AMBIENT;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    protected void pushEntities() {
    }

    protected boolean isFlapping() {
        return true;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    protected void tickDeath() {
        if (!this.level().isClientSide && this.isWarted() && this.level().getServer().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHER_WART, MHelper.randRange(1, 3, this.random)));
        }
        super.tickDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 5;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        EntityFlyingPig pig = (EntityFlyingPig)NetherEntities.FLYING_PIG.type().create(this.level());
        pig.setWarted(pig.isWarted());
        return pig;
    }

    public boolean isFood(ItemStack stack) {
        return stack.getItem() == Items.NETHER_WART;
    }

    class FindFoodGoal
    extends Goal {
        private List<ItemEntity> foods;
        private ItemEntity target;

        FindFoodGoal() {
        }

        public boolean canUse() {
            return this.hasNearFood();
        }

        public void start() {
            BlockPos pos = this.getFood();
            Path path = EntityFlyingPig.this.navigation.createPath(pos, 1);
            if (path != null) {
                EntityFlyingPig.this.navigation.moveTo(path, (double)EntityFlyingPig.this.getFlyingSpeed());
                EntityFlyingPig.this.setRoosting(false);
            }
            super.start();
        }

        public boolean canContinueToUse() {
            return this.target.isAlive() && EntityFlyingPig.this.navigation.isInProgress();
        }

        public void stop() {
            if (this.target.isAlive() && (double)this.target.distanceTo((Entity)EntityFlyingPig.this) < 1.3) {
                ItemStack stack = this.target.getItem();
                ItemParticleOption effect = new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)stack.getItem()));
                for (ServerPlayer serverPlayerEntity : EntityFlyingPig.this.level().players()) {
                    if (!(serverPlayerEntity.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ()) < 4096.0)) continue;
                    serverPlayerEntity.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)effect, false, this.target.getX(), this.target.getY() + 0.2, this.target.getZ(), 0.2f, 0.2f, 0.2f, 0.0f, 16));
                }
                EntityFlyingPig.this.eat(EntityFlyingPig.this.level(), stack);
                this.target.kill();
                EntityFlyingPig.this.heal(stack.getCount());
                EntityFlyingPig.this.setDeltaMovement(0.0, 0.2f, 0.0);
            }
            EntityFlyingPig.this.preGoal = this;
            super.stop();
        }

        private BlockPos getFood() {
            this.target = this.foods.get(EntityFlyingPig.this.random.nextInt(this.foods.size()));
            return this.target.blockPosition();
        }

        private boolean hasNearFood() {
            AABB box = new AABB(EntityFlyingPig.this.blockPosition()).inflate(16.0);
            this.foods = EntityFlyingPig.this.level().getEntitiesOfClass(ItemEntity.class, box, entity -> {
                FoodProperties foodProperties = (FoodProperties)entity.getItem().get(DataComponents.FOOD);
                return foodProperties != null;
            });
            return !this.foods.isEmpty();
        }
    }

    class SittingGoal
    extends Goal {
        int timer;
        int ammount;

        SittingGoal() {
        }

        public boolean canUse() {
            return EntityFlyingPig.this.isRoosting();
        }

        public boolean canContinueToUse() {
            return this.timer < this.ammount;
        }

        public void start() {
            this.timer = 0;
            this.ammount = MHelper.randRange(80, 160, EntityFlyingPig.this.random);
            EntityFlyingPig.this.setDeltaMovement(0.0, 0.0, 0.0);
            EntityFlyingPig.this.setYBodyRot(EntityFlyingPig.this.random.nextFloat() * ((float)Math.PI * 2));
            super.start();
        }

        public void stop() {
            EntityFlyingPig.this.setRoosting(false);
            EntityFlyingPig.this.setDeltaMovement(0.0, -0.1f, 0.0);
            EntityFlyingPig.this.preGoal = this;
            super.stop();
        }

        public void tick() {
            ++this.timer;
            super.tick();
        }
    }

    class RoostingGoal
    extends Goal {
        BlockPos roosting;

        RoostingGoal() {
        }

        public boolean canUse() {
            return !(EntityFlyingPig.this.preGoal instanceof SittingGoal) && EntityFlyingPig.this.navigation.isDone() && !EntityFlyingPig.this.isRoosting() && EntityFlyingPig.this.random.nextInt(4) == 0;
        }

        public boolean canContinueToUse() {
            return EntityFlyingPig.this.navigation.isInProgress();
        }

        public void start() {
            Path path;
            BlockPos pos = this.getRoostingLocation();
            if (pos != null && (path = EntityFlyingPig.this.navigation.createPath(pos, 1)) != null) {
                EntityFlyingPig.this.navigation.moveTo(path, (double)EntityFlyingPig.this.getFlyingSpeed());
                this.roosting = pos;
            }
            super.start();
        }

        public void stop() {
            if (this.roosting != null) {
                EntityFlyingPig.this.setPosRaw((double)this.roosting.getX() + 0.5, (double)this.roosting.getY() - 0.25, (double)this.roosting.getZ() + 0.5);
                EntityFlyingPig.this.setRoosting(true);
                EntityFlyingPig.this.preGoal = this;
            }
            super.stop();
        }

        private BlockPos getRoostingLocation() {
            int up;
            BlockPos pos = EntityFlyingPig.this.blockPosition();
            Level world = EntityFlyingPig.this.level();
            if (world.getBlockState((pos = pos.relative(Direction.UP, up = BlocksHelper.upRay((LevelAccessor)world, pos, 16))).above()).getBlock() == Blocks.NETHER_WART_BLOCK) {
                return pos;
            }
            return null;
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return EntityFlyingPig.this.navigation.isDone() && !EntityFlyingPig.this.isRoosting();
        }

        public boolean canContinueToUse() {
            return EntityFlyingPig.this.navigation.isInProgress() && EntityFlyingPig.this.random.nextInt(32) > 0;
        }

        public void start() {
            if (EntityFlyingPig.this.level().getFluidState(EntityFlyingPig.this.blockPosition()).isEmpty()) {
                BlockPos pos = this.getRandomLocation();
                Path path = EntityFlyingPig.this.navigation.createPath(pos, 1);
                if (path != null) {
                    EntityFlyingPig.this.navigation.moveTo(path, (double)EntityFlyingPig.this.getFlyingSpeed());
                } else {
                    EntityFlyingPig.this.setDeltaMovement(0.0, -0.2, 0.0);
                }
                EntityFlyingPig.this.setRoosting(false);
            } else {
                EntityFlyingPig.this.setDeltaMovement(0.0, 1.0, 0.0);
            }
            super.start();
        }

        private BlockPos getRandomLocation() {
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
            bpos.set(EntityFlyingPig.this.getX(), EntityFlyingPig.this.getY(), EntityFlyingPig.this.getZ());
            Vec3 angle = EntityFlyingPig.this.getViewVector(0.0f);
            Vec3 airTarget = HoverRandomPos.getPos((PathfinderMob)EntityFlyingPig.this, (int)8, (int)7, (double)angle.x, (double)angle.z, (float)1.5707964f, (int)2, (int)1);
            if (airTarget == null) {
                airTarget = HoverRandomPos.getPos((PathfinderMob)EntityFlyingPig.this, (int)32, (int)10, (double)angle.x, (double)angle.z, (float)1.5707964f, (int)3, (int)1);
            }
            if (airTarget == null) {
                bpos.setX(bpos.getX() + this.randomRange(32));
                bpos.setZ(bpos.getZ() + this.randomRange(32));
                bpos.setY(bpos.getY() + this.randomRange(32));
                return bpos;
            }
            bpos.set(airTarget.x(), airTarget.y(), airTarget.z());
            BlockPos down = bpos.below();
            if (EntityFlyingPig.this.level().getBlockState(down).isCollisionShapeFullBlock((BlockGetter)EntityFlyingPig.this.level(), down)) {
                bpos.move(Direction.UP);
            }
            while (!EntityFlyingPig.this.level().getFluidState((BlockPos)bpos).isEmpty()) {
                bpos.move(Direction.UP);
            }
            return bpos;
        }

        private int randomRange(int side) {
            RandomSource random = EntityFlyingPig.this.random;
            return random.nextInt(side + 1) - (side >> 1);
        }

        public void stop() {
            EntityFlyingPig.this.preGoal = this;
            super.stop();
        }
    }
}

