/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.betternether.registry.SoundsRegistry;

public class EntityHydrogenJellyfish
extends DespawnableAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.defineId(EntityHydrogenJellyfish.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private Vec3 preVelocity;
    private Vec3 newVelocity = new Vec3(0.0, 0.0, 0.0);
    private int timer;
    private int timeOut;
    private float prewYaw;
    private float nextYaw;

    public EntityHydrogenJellyfish(EntityType<? extends EntityHydrogenJellyfish> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SCALE, (Object)Float.valueOf(0.5f + this.random.nextFloat()));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 0.5).add(Attributes.FLYING_SPEED, 0.05).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 20.0);
    }

    protected boolean isFlapping() {
        return true;
    }

    protected void jumpInLiquid(TagKey<Fluid> fluid) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
    }

    public boolean isNoGravity() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("Scale", this.getScale());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Scale")) {
            this.entityData.set(SCALE, (Object)Float.valueOf(tag.getFloat("Scale")));
        }
        this.refreshDimensions();
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public float getScale() {
        return ((Float)this.entityData.get(SCALE)).floatValue();
    }

    public void playerTouch(Player player) {
        player.hurt(player.damageSources().generic(), 3.0f);
    }

    public void refreshDimensions() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        super.refreshDimensions();
        this.setPosRaw(x, y, z);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (SCALE.equals(data)) {
            this.refreshDimensions();
        }
    }

    protected void customServerAiStep() {
        ++this.timer;
        if (this.timer > this.timeOut) {
            this.prewYaw = this.getYRot();
            this.nextYaw = this.random.nextFloat() * 360.0f;
            double rads = Math.toRadians(this.nextYaw + 90.0f);
            double vx = Math.cos(rads) * (double)this.getFlyingSpeed();
            double vz = Math.sin(rads) * (double)this.getFlyingSpeed();
            BlockPos bp = this.blockPosition();
            double vy = this.random.nextDouble() * (double)this.getFlyingSpeed() * 0.75;
            if (this.level().getBlockState(bp).isAir() && this.level().getBlockState(bp.below(2)).isAir() && this.level().getBlockState(bp.below(3)).isAir() && this.level().getBlockState(bp.below(4)).isAir()) {
                vy = -vy;
            }
            this.preVelocity = this.newVelocity;
            this.newVelocity = new Vec3(vx, vy, vz);
            this.timer = 0;
            this.timeOut = this.random.nextInt(300) + 120;
        }
        if (this.timer <= 120) {
            if (this.getYRot() != this.nextYaw) {
                float delta = (float)this.timer / 120.0f;
                this.setYRot(EntityHydrogenJellyfish.lerpAngleDegrees(delta, this.prewYaw, this.nextYaw));
                this.setDeltaMovement(Mth.lerp((double)delta, (double)this.preVelocity.x, (double)this.newVelocity.x), Mth.lerp((double)delta, (double)this.preVelocity.y, (double)this.newVelocity.y), Mth.lerp((double)delta, (double)this.preVelocity.z, (double)this.newVelocity.z));
            }
        } else {
            this.setDeltaMovement(this.newVelocity);
        }
    }

    public static float lerpAngleDegrees(float delta, float first, float second) {
        return first + delta * Mth.wrapDegrees((float)(second - first));
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public void die(DamageSource source) {
        super.die(source);
        if (this.level().isClientSide) {
            float scale = this.getScale() * 3.0f;
            for (int i = 0; i < 20; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + this.random.nextGaussian() * (double)scale, this.getEyeY() + this.random.nextGaussian() * (double)scale, this.getZ() + this.random.nextGaussian() * (double)scale, 0.0, 0.0, 0.0);
            }
        } else if (source != this.level().damageSources().fellOutOfWorld()) {
            this.level().explode((Entity)this, this.getX(), this.getEyeY(), this.getZ(), 7.0f * this.getScale(), Level.ExplosionInteraction.MOB);
        }
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)SoundsRegistry.MOB_JELLYFISH.value();
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.WITHER) || source.getDirectEntity() != null || source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, amount);
        }
        return false;
    }

    public static boolean canSpawn(EntityType<? extends EntityHydrogenJellyfish> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        try {
            AABB box = new AABB(pos).inflate(64.0, 256.0, 64.0);
            List list = world.getEntitiesOfClass(EntityHydrogenJellyfish.class, box, entity -> true);
            return list.size() < 4;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean isFlying() {
        return !this.onGround();
    }
}

