/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.entity.EntityNagaProjectile;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.SoundsRegistry;

public class EntityNaga
extends Monster
implements RangedAttackMob,
Enemy {
    public EntityNaga(EntityType<? extends EntityNaga> type, Level world) {
        super(type, world);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 2.0);
    }

    public void performRangedAttack(LivingEntity target, float f) {
        EntityNagaProjectile projectile = (EntityNagaProjectile)NetherEntities.NAGA_PROJECTILE.create(this.level());
        projectile.absMoveTo(this.getX(), this.getEyeY(), this.getZ(), 0.0f, 0.0f);
        projectile.setParams((LivingEntity)this, (Entity)target);
        this.level().addFreshEntity((Entity)projectile);
        this.playSound((SoundEvent)SoundsRegistry.MOB_NAGA_ATTACK.value(), MHelper.randRange(3.0f, 5.0f, this.random), MHelper.randRange(0.75f, 1.25f, this.random));
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return effect.getEffect() != MobEffects.WITHER && super.canBeAffected(effect);
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)SoundsRegistry.MOB_NAGA_IDLE.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SKELETON_DEATH;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    public static boolean canSpawn(EntityType<? extends EntityNaga> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getDifficulty() != Difficulty.PEACEFUL && world.getMaxLocalRawBrightness(pos) < 8;
    }
}

