/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.SoundsRegistry;

public class EntitySkull
extends Monster
implements FlyingAnimal {
    private static double particleX;
    private static double particleY;
    private static double particleZ;
    private int attackTick;
    private int dirTickTick;
    private int collideTick;

    public EntitySkull(EntityType<? extends EntitySkull> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new SkullLookControl(this, (Mob)this);
        this.setPathfindingMalus(PathType.LAVA, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.xpReward = 1;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof Player ? this.getSpeed() * 0.1f : 0.5f;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    public void playerTouch(Player player) {
        ++this.collideTick;
        if (this.isAlive() && this.collideTick > 25) {
            this.collideTick = 0;
            DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
            if (player.hurt(damageSource, this.getAttackDamage())) {
                this.playSound(SoundEvents.SLIME_ATTACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)player, (DamageSource)damageSource);
                }
            }
            if (this.random.nextInt(16) == 0) {
                player.igniteForSeconds(3.0f);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.random.nextInt(3) == 0) {
            this.updateParticlePos();
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.random.nextInt(3) == 0) {
            this.updateParticlePos();
            this.level().addParticle((ParticleOptions)ParticleTypes.DRIPPING_LAVA, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.random.nextInt(3) == 0) {
            this.updateParticlePos();
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
        if (this.attackTick > 40 && this.isAlive()) {
            Player target = this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), 20.0, true);
            if (target != null && this.hasLineOfSight((Entity)target)) {
                this.attackTick = 0;
                Vec3 velocity = target.position().add(0.0, (double)(target.getBbHeight() * 0.5f), 0.0).subtract(this.position()).normalize().scale((double)this.getFlyingSpeed());
                this.setDeltaMovement(velocity);
                this.lookAt((Entity)target, 360.0f, 360.0f);
                this.playSound((SoundEvent)SoundsRegistry.MOB_SKULL_FLIGHT.value(), MHelper.randRange(0.15f, 0.3f, this.random), MHelper.randRange(0.9f, 1.5f, this.random));
            } else if (this.dirTickTick < 0) {
                this.dirTickTick = MHelper.randRange(20, 60, this.random);
                this.moveRandomDir();
            }
        } else if (this.dirTickTick < 0) {
            this.dirTickTick = MHelper.randRange(20, 60, this.random);
            this.moveRandomDir();
        }
        ++this.attackTick;
        --this.dirTickTick;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SKELETON_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.SKELETON_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SKELETON_DEATH;
    }

    private void moveRandomDir() {
        double dz;
        double dy;
        double dx = this.random.nextDouble() - 0.5;
        double l = dx * dx + (dy = this.random.nextDouble() - 0.5) * dy + (dz = this.random.nextDouble() - 0.5) * dz;
        l = l == 0.0 ? 1.0 : (double)((float)Math.sqrt(l));
        this.setDeltaMovement(dx /= (l /= (double)this.getFlyingSpeed()), dy /= l, dz /= l);
        this.lookAt(this.position().add(this.getDeltaMovement()));
        this.playSound((SoundEvent)SoundsRegistry.MOB_SKULL_FLIGHT.value(), MHelper.randRange(0.15f, 0.3f, this.random), MHelper.randRange(0.75f, 1.25f, this.random));
    }

    private void lookAt(Vec3 target) {
        double d = target.x() - this.getX();
        double e = target.z() - this.getZ();
        double g = target.y() - this.getY();
        double h = Math.sqrt(d * d + e * e);
        float i = (float)(Mth.atan2((double)e, (double)d) * 57.2957763671875) - 90.0f;
        float j = (float)(-(Mth.atan2((double)g, (double)h) * 57.2957763671875));
        this.setXRot(j);
        this.setYRot(i);
    }

    private void updateParticlePos() {
        particleX = this.random.nextDouble() - 0.5;
        double l = particleX * particleX + (particleY = this.random.nextDouble() - 0.5) * particleY + (particleZ = this.random.nextDouble() - 0.5) * particleZ;
        l = l == 0.0 ? 1.0 : (double)((float)Math.sqrt(l));
        particleX = particleX * 0.5 / l + this.getX();
        particleY = particleY * 0.5 / l + this.getY();
        particleZ = particleZ * 0.5 / l + this.getZ();
    }

    public double getEyeY() {
        return super.getEyeY();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEyeHeight(Pose pose) {
        return this.getDimensions(pose).height() * 0.5f;
    }

    protected boolean isFlapping() {
        return true;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public static boolean canSpawn(EntityType<? extends EntitySkull> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        try {
            if (world.getDifficulty() == Difficulty.PEACEFUL || world.getMaxLocalRawBrightness(pos) > 7) {
                return false;
            }
            if (pos.getY() >= world.dimensionType().minY()) {
                return false;
            }
            AABB box = new AABB(pos).inflate(256.0, 256.0, 256.0);
            List list = world.getEntitiesOfClass(EntitySkull.class, box, entity -> true);
            return list.size() < 4;
        }
        catch (Exception e) {
            return true;
        }
    }

    class SkullLookControl
    extends LookControl {
        SkullLookControl(EntitySkull this$0, Mob entity) {
            super(entity);
        }

        protected boolean resetXRotOnTick() {
            return false;
        }
    }
}

