/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public abstract class RenderPhaseAccessor
extends RenderStateShard {
    protected static final RenderStateShard.TransparencyStateShard ALPHA_ADD_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("alpha_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final Function<ResourceLocation, RenderType> FIREFLY_RENDER_LAYER = Util.memoize(RenderPhaseAccessor::getFireflySetup);

    public RenderPhaseAccessor(String name, Runnable beginAction, Runnable endAction) {
        super(name, beginAction, endAction);
    }

    private static final RenderType getFireflySetup(ResourceLocation texture) {
        RenderType.CompositeState multiPhaseParameters = RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_TRANSLUCENT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).setWriteMaskState(COLOR_WRITE).setCullState(NO_CULL).setOverlayState(OVERLAY).setLightmapState(LIGHTMAP).setTransparencyState(ALPHA_ADD_TRANSPARENCY).createCompositeState(false);
        return RenderType.create((String)"firefly", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)multiPhaseParameters);
    }

    public static RenderType getFirefly(ResourceLocation texture) {
        return FIREFLY_RENDER_LAYER.apply(texture);
    }
}

