/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.entity.render;

import java.io.IOException;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.betterx.betternether.entity.render.DebugShader;
import org.jetbrains.annotations.Nullable;

abstract class ShaderDebugHelper
extends RenderStateShard {
    static int targetCacheID = 50;
    protected static ShaderInstance myDebugShader;
    protected static RenderStateShard.ShaderStateShard MY_DEBUG_SHADER;
    private static int debugCachingID;
    private static RenderType reloadableDebugLayer;

    ShaderDebugHelper(String name, Runnable beginAction, Runnable endAction) {
        super(name, beginAction, endAction);
    }

    @Nullable
    static ShaderInstance getRenderTypeMyShader() {
        return myDebugShader;
    }

    static void initDebugShader() {
        if (myDebugShader == null) {
            ResourceManager factory = Minecraft.getInstance().getResourceManager();
            try {
                myDebugShader = new DebugShader((ResourceProvider)factory);
                MY_DEBUG_SHADER = new RenderStateShard.ShaderStateShard(ShaderDebugHelper::getRenderTypeMyShader);
            }
            catch (IOException e) {
                e.printStackTrace();
                MY_DEBUG_SHADER = RenderStateShard.RENDERTYPE_EYES_SHADER;
            }
        }
    }

    static RenderType getDebugLayer(ResourceLocation texture, Function<ResourceLocation, RenderType> setup) {
        if (debugCachingID < targetCacheID || reloadableDebugLayer == null) {
            myDebugShader = null;
            System.out.println("Reloading RenderLayer: " + targetCacheID);
            debugCachingID = targetCacheID;
            reloadableDebugLayer = setup.apply(texture);
        }
        return reloadableDebugLayer;
    }

    static {
        debugCachingID = 0;
        reloadableDebugLayer = null;
    }
}

