/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.items.materials;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.betternether.registry.NetherItems;
import org.jetbrains.annotations.NotNull;

public enum BNToolMaterial implements Tier
{
    CINCINNASITE((TagKey<Block>)Tiers.IRON.getIncorrectBlocksForDrops(), 2, 512, 6.2f, 2.5f, 16, (ItemLike)NetherItems.CINCINNASITE_INGOT),
    CINCINNASITE_DIAMOND((TagKey<Block>)Tiers.DIAMOND.getIncorrectBlocksForDrops(), 3, 2061, 8.2f, 3.7f, 14, (ItemLike)Items.DIAMOND),
    NETHER_RUBY((TagKey<Block>)Tiers.DIAMOND.getIncorrectBlocksForDrops(), 3, 2561, 7.1f, 3.1f, 18, (ItemLike)NetherItems.NETHER_RUBY),
    FLAMING_RUBY((TagKey<Block>)Tiers.NETHERITE.getIncorrectBlocksForDrops(), 4, 2861, 10.4f, 6.0f, 32, (ItemLike)Items.SCULK_CATALYST);

    private final int uses;
    private final float speed;
    private final int level;
    private final int enchantibility;
    private final float damage;
    private final ItemLike reapair;
    public final TagKey<Block> incorrectBlocksForDrops;

    private BNToolMaterial(TagKey<Block> incorrectBlocksForDrops, int level, int uses, float speed, float damage, int enchantibility, ItemLike reapair) {
        this.incorrectBlocksForDrops = incorrectBlocksForDrops;
        this.uses = uses;
        this.speed = speed;
        this.level = level;
        this.enchantibility = enchantibility;
        this.damage = damage;
        this.reapair = reapair;
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.damage;
    }

    @NotNull
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    @Deprecated(forRemoval=true)
    public int getLevel() {
        return this.level;
    }

    public int getEnchantmentValue() {
        return this.enchantibility;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.of((ItemLike[])new ItemLike[]{this.reapair});
    }
}

