/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.mixin.common;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.betterx.betternether.blocks.BlockStatueRespawner;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class}, remap=false)
public abstract class PlayerEntityMixin {
    @Shadow
    @Nullable
    private BlockPos respawnPosition;

    @Shadow
    public abstract ServerLevel serverLevel();

    @Inject(method={"getRespawnPosition"}, at={@At(value="HEAD")}, cancellable=true)
    private void bn_statueRespawn(CallbackInfoReturnable<BlockPos> info) {
        Optional<Vec3> op;
        BlockPos pos = this.respawnPosition;
        if (pos == null) {
            return;
        }
        BlockState blockState = this.serverLevel().getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof BlockStatueRespawner && (op = PlayerEntityMixin.bn_findRespawnPosition(this.serverLevel(), pos, blockState)).isPresent()) {
            info.setReturnValue((Object)new BlockPos((int)op.get().x, (int)op.get().y, (int)op.get().z));
            info.cancel();
        }
    }

    @Unique
    private static Optional<Vec3> bn_findRespawnPosition(ServerLevel world, BlockPos pos, BlockState state) {
        BlockState state2;
        if (((Boolean)state.getValue((Property)BlockStatueRespawner.TOP)).booleanValue()) {
            pos = pos.below();
        }
        if (!(state2 = world.getBlockState(pos = pos.relative((Direction)state.getValue((Property)BlockStatueRespawner.FACING)))).blocksMotion() && state2.getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            return Optional.of(Vec3.atLowerCornerOf((Vec3i)pos).add(0.5, 0.0, 0.5));
        }
        return Optional.empty();
    }
}

