/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.bclib.blocks.BaseBarrelBlock;
import org.betterx.bclib.blocks.BaseChestBlock;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.blockentities.BNBrewingStandBlockEntity;
import org.betterx.betternether.blockentities.BlockEntityChestOfDrawers;
import org.betterx.betternether.blockentities.BlockEntityForge;
import org.betterx.betternether.blockentities.BlockEntityFurnace;
import org.betterx.betternether.blocks.BlockNetherFurnace;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockEntitiesRegistry {
    public static BlockEntityType<BlockEntityForge> CINCINNASITE_FORGE;
    public static BlockEntityType<BlockEntityFurnace> NETHERRACK_FURNACE;
    public static BlockEntityType<BlockEntityChestOfDrawers> CHEST_OF_DRAWERS;
    public static BlockEntityType<BNBrewingStandBlockEntity> NETHER_BREWING_STAND;

    public static void register() {
    }

    public static void register(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.BLOCK_ENTITY_TYPE)) {
            event.register(Registries.BLOCK_ENTITY_TYPE, helper -> {
                CINCINNASITE_FORGE = BlockEntityType.Builder.of(BlockEntityForge::new, (Block[])new Block[]{NetherBlocks.CINCINNASITE_FORGE}).build(null);
                NETHERRACK_FURNACE = BlockEntityType.Builder.of(BlockEntityFurnace::new, (Block[])BlockEntitiesRegistry.getFurnaces()).build(null);
                CHEST_OF_DRAWERS = BlockEntityType.Builder.of(BlockEntityChestOfDrawers::new, (Block[])new Block[]{NetherBlocks.CHEST_OF_DRAWERS}).build(null);
                NETHER_BREWING_STAND = BlockEntityType.Builder.of(BNBrewingStandBlockEntity::new, (Block[])new Block[]{NetherBlocks.NETHER_BREWING_STAND}).build(null);
                helper.register(BetterNether.C.mk("forge"), CINCINNASITE_FORGE);
                helper.register(BetterNether.C.mk("furnace"), NETHERRACK_FURNACE);
                helper.register(BetterNether.C.mk("chest_of_drawers"), CHEST_OF_DRAWERS);
                helper.register(BetterNether.C.mk("nether_brewing_stand"), NETHER_BREWING_STAND);
            });
        }
    }

    private static Block[] getChests() {
        ArrayList result = new ArrayList();
        NetherBlocks.getModBlocks().forEach(block -> {
            if (block instanceof BaseChestBlock) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }

    private static Block[] getBarrels() {
        ArrayList result = new ArrayList();
        NetherBlocks.getModBlocks().forEach(block -> {
            if (block instanceof BaseBarrelBlock) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }

    private static Block[] getFurnaces() {
        ArrayList result = new ArrayList();
        NetherBlocks.getModBlocks().forEach(block -> {
            if (block instanceof BlockNetherFurnace) {
                result.add(block);
            }
        });
        return result.toArray(new Block[0]);
    }
}

