/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import org.betterx.betternether.BN;

public class BrewingRegistry {
    private static final List<BrewingRecipe> RECIPES = new ArrayList<BrewingRecipe>();
    private static final ResourceLocation BARREL_CACTUS_ID = BN.id("barrel_cactus");
    private static final ResourceLocation HOOK_MUSHROOM_ID = BN.id("hook_mushroom");
    private static boolean initialized = false;

    public static void register() {
        BrewingRegistry.ensureRecipes();
    }

    private static void ensureRecipes() {
        if (initialized) {
            return;
        }
        initialized = true;
        BrewingRegistry.register(BrewingRegistry.stackFromId(BARREL_CACTUS_ID), new ItemStack((ItemLike)Items.GLASS_BOTTLE), BrewingRegistry.makePotion((Holder<Potion>)Potions.WATER));
        BrewingRegistry.register(BrewingRegistry.stackFromId(HOOK_MUSHROOM_ID), BrewingRegistry.makePotion((Holder<Potion>)Potions.AWKWARD), BrewingRegistry.makePotion((Holder<Potion>)Potions.HEALING));
    }

    private static ItemStack stackFromId(ResourceLocation id) {
        Item item = (Item)BuiltInRegistries.ITEM.get(id);
        return item == Items.AIR ? ItemStack.EMPTY : new ItemStack((ItemLike)item);
    }

    private static void register(ItemStack source, ItemStack bottle, ItemStack result) {
        if (source.isEmpty()) {
            return;
        }
        RECIPES.add(new BrewingRecipe(source, bottle, result));
    }

    private static ItemStack makePotion(Holder<Potion> potion) {
        return PotionContents.createItemStack((Item)Items.POTION, potion);
    }

    public static ItemStack getResult(ItemStack source, ItemStack bottle) {
        BrewingRegistry.ensureRecipes();
        for (BrewingRecipe recipe : RECIPES) {
            if (!recipe.isValid(source, bottle)) continue;
            return recipe.getResult();
        }
        return null;
    }

    public static boolean isValidIngridient(ItemStack source) {
        BrewingRegistry.ensureRecipes();
        for (BrewingRecipe recipe : RECIPES) {
            if (!recipe.isValid(source)) continue;
            return true;
        }
        return false;
    }

    public static class BrewingRecipe {
        private final ItemStack source;
        private final ItemStack bottle;
        private final ItemStack result;

        public BrewingRecipe(ItemStack source, ItemStack bottle, ItemStack result) {
            this.source = source;
            this.bottle = bottle;
            this.result = result;
        }

        public boolean isValid(ItemStack source, ItemStack bottle) {
            return ItemStack.isSameItem((ItemStack)this.source, (ItemStack)source) && ItemStack.isSameItem((ItemStack)this.bottle, (ItemStack)bottle);
        }

        public boolean isValid(ItemStack source) {
            return ItemStack.isSameItem((ItemStack)this.source, (ItemStack)source);
        }

        public ItemStack getResult() {
            return this.result;
        }
    }
}

