/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.bclib.api.v2.spawning.SpawnRuleBuilder;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.bclib.interfaces.SpawnRule;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.entity.EntityFirefly;
import org.betterx.betternether.entity.EntityFlyingPig;
import org.betterx.betternether.entity.EntityHydrogenJellyfish;
import org.betterx.betternether.entity.EntityJungleSkeleton;
import org.betterx.betternether.entity.EntityNaga;
import org.betterx.betternether.entity.EntityNagaProjectile;
import org.betterx.betternether.entity.EntitySkull;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.betternether.world.biomes.util.NetherBiomeBuilder;
import org.betterx.ui.ColorUtil;

@EventBusSubscriber(modid="betternether", bus=EventBusSubscriber.Bus.MOD)
public class NetherEntities {
    public static final Map<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> ATTR_BUILDERS = Maps.newHashMap();
    private static final List<BCLEntityWrapper<?>> NETHER_ENTITIES = Lists.newArrayList();
    public static EntityType<EntityNagaProjectile> NAGA_PROJECTILE;
    public static BCLEntityWrapper<EntityFirefly> FIREFLY;
    public static BCLEntityWrapper<EntityHydrogenJellyfish> HYDROGEN_JELLYFISH;
    public static BCLEntityWrapper<EntityNaga> NAGA;
    public static BCLEntityWrapper<EntityFlyingPig> FLYING_PIG;
    public static BCLEntityWrapper<EntityJungleSkeleton> JUNGLE_SKELETON;
    public static BCLEntityWrapper<EntitySkull> SKULL;
    public static final int MAX_FLOAT_HEIGHT = 7;
    public static final SpawnRule RULE_FLOAT_NOT_ABOVE_LAVA;
    public static final SpawnRule RULE_FLOAT_ABOVE_LAVA;

    private static <T extends Mob> BCLEntityWrapper<T> register(String name, MobCategory group, float width, float height, EntityType.EntityFactory<T> entity, AttributeSupplier.Builder attributes, boolean fixedSize, int eggColor, int dotsColor) {
        ResourceLocation id = BetterNether.C.id(name);
        EntityType type = EntityType.Builder.of(entity, (MobCategory)group).sized(width, height).fireImmune().build(id.toString());
        ATTR_BUILDERS.put((EntityType<? extends LivingEntity>)type, attributes);
        NetherItems.makeEgg("spawn_egg_" + name, (EntityType<? extends Mob>)type, eggColor, dotsColor);
        return new BCLEntityWrapper(type, true);
    }

    private static boolean testSpawnAboveLava(LevelAccessor world, BlockPos pos, boolean allow) {
        int h = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)pos, (int)9);
        if (h > 7) {
            return false;
        }
        for (int i = 1; i <= h + 1; ++i) {
            if (!BlocksHelper.isLava((BlockState)world.getBlockState(pos.below(i)))) continue;
            return allow;
        }
        return !allow;
    }

    public static void register() {
        NetherEntities.setupSpawnRules();
    }

    public static void registerEntity(String name, EntityType<? extends LivingEntity> entity) {
        NetherEntities.registerEntity(name, entity, Mob.createMobAttributes());
    }

    public static void registerEntity(String name, EntityType<? extends LivingEntity> entity, AttributeSupplier.Builder builder) {
        ATTR_BUILDERS.put(entity, builder);
    }

    public static boolean isNetherEntity(Entity entity) {
        return NETHER_ENTITIES.contains(entity.getType());
    }

    @SubscribeEvent
    public static void onRegisterAttributes(EntityAttributeCreationEvent event) {
        ATTR_BUILDERS.forEach((type, builder) -> event.put(type, builder.build()));
    }

    private static void setupSpawnRules() {
        if (FIREFLY == null || HYDROGEN_JELLYFISH == null || NAGA == null || FLYING_PIG == null || JUNGLE_SKELETON == null || SKULL == null) {
            return;
        }
        SpawnRuleBuilder.start(FIREFLY).belowMaxHeight().customRule(RULE_FLOAT_NOT_ABOVE_LAVA).maxNearby(32, 64).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(HYDROGEN_JELLYFISH).belowMaxHeight().maxNearby(24, 64).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(NAGA).hostile(8).maxNearby(32, 64).buildOnGround(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(FLYING_PIG).belowMaxHeight().customRule(RULE_FLOAT_NOT_ABOVE_LAVA).maxNearby(16, 64).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(JUNGLE_SKELETON).notPeaceful().maxNearby(16, 64).buildOnGround(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(SKULL).belowMaxHeight().vanillaHostile().maxNearby(16, 64).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
    }

    public static void onRegister(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.ENTITY_TYPE)) {
            return;
        }
        event.register(Registries.ENTITY_TYPE, helper -> {
            NAGA_PROJECTILE = EntityType.Builder.of(EntityNagaProjectile::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).noSummon().build(BetterNether.C.mk("naga_projectile").toString());
            helper.register(BetterNether.C.mk("naga_projectile"), NAGA_PROJECTILE);
            ATTR_BUILDERS.put(NAGA_PROJECTILE, Mob.createMobAttributes());
            FIREFLY = NetherEntities.register("firefly", MobCategory.AMBIENT, 0.5f, 0.5f, EntityFirefly::new, EntityFirefly.createMobAttributes(), true, ColorUtil.color((int)255, (int)223, (int)168), ColorUtil.color((int)233, (int)182, (int)95));
            helper.register(BetterNether.C.mk("firefly"), (Object)FIREFLY.type());
            HYDROGEN_JELLYFISH = NetherEntities.register("hydrogen_jellyfish", MobCategory.AMBIENT, 2.0f, 5.0f, EntityHydrogenJellyfish::new, EntityHydrogenJellyfish.createMobAttributes(), false, ColorUtil.color((int)253, (int)164, (int)24), ColorUtil.color((int)88, (int)21, (int)4));
            helper.register(BetterNether.C.mk("hydrogen_jellyfish"), (Object)HYDROGEN_JELLYFISH.type());
            NAGA = NetherEntities.register("naga", MobCategory.MONSTER, 0.625f, 2.75f, EntityNaga::new, EntityNaga.createMobAttributes(), true, ColorUtil.color((int)12, (int)12, (int)12), ColorUtil.color((int)210, (int)90, (int)26));
            helper.register(BetterNether.C.mk("naga"), (Object)NAGA.type());
            FLYING_PIG = NetherEntities.register("flying_pig", MobCategory.AMBIENT, 1.0f, 1.25f, EntityFlyingPig::new, EntityFlyingPig.createMobAttributes(), true, ColorUtil.color((int)241, (int)140, (int)93), ColorUtil.color((int)176, (int)58, (int)47));
            helper.register(BetterNether.C.mk("flying_pig"), (Object)FLYING_PIG.type());
            JUNGLE_SKELETON = NetherEntities.register("jungle_skeleton", MobCategory.MONSTER, 0.6f, 1.99f, EntityJungleSkeleton::new, EntityJungleSkeleton.createMonsterAttributes(), true, ColorUtil.color((int)134, (int)162, (int)149), ColorUtil.color((int)6, (int)111, (int)79));
            helper.register(BetterNether.C.mk("jungle_skeleton"), (Object)JUNGLE_SKELETON.type());
            SKULL = NetherEntities.register("skull", MobCategory.MONSTER, 0.625f, 0.625f, EntitySkull::new, EntitySkull.createMobAttributes(), true, ColorUtil.color((int)24, (int)19, (int)19), ColorUtil.color((int)255, (int)28, (int)18));
            helper.register(BetterNether.C.mk("skull"), (Object)SKULL.type());
            KnownSpawnTypes.SKULL.setWrapper(SKULL);
            KnownSpawnTypes.FIREFLY.setWrapper(FIREFLY);
            KnownSpawnTypes.HYDROGEN_JELLYFISH.setWrapper(HYDROGEN_JELLYFISH);
            KnownSpawnTypes.NAGA.setWrapper(NAGA);
            KnownSpawnTypes.FLYING_PIG.setWrapper(FLYING_PIG);
            KnownSpawnTypes.JUNGLE_SKELETON.setWrapper(JUNGLE_SKELETON);
            NetherEntities.setupSpawnRules();
        });
    }

    static {
        RULE_FLOAT_NOT_ABOVE_LAVA = (type, world, spawnReason, pos, random) -> NetherEntities.testSpawnAboveLava(world, pos, false);
        RULE_FLOAT_ABOVE_LAVA = (type, world, spawnReason, pos, random) -> NetherEntities.testSpawnAboveLava(world, pos, true);
    }

    public static enum KnownSpawnTypes {
        GHAST(50, 4, 4, EntityType.GHAST),
        ZOMBIFIED_PIGLIN(100, 4, 4, EntityType.ZOMBIFIED_PIGLIN),
        MAGMA_CUBE(2, 4, 4, EntityType.MAGMA_CUBE),
        SKULL(2, 2, 4, SKULL),
        ENDERMAN(1, 4, 4, EntityType.ENDERMAN),
        PIGLIN(15, 4, 4, EntityType.PIGLIN),
        STRIDER(60, 1, 2, EntityType.STRIDER),
        HOGLIN(9, 1, 2, EntityType.HOGLIN),
        FIREFLY(5, 1, 3, FIREFLY),
        HYDROGEN_JELLYFISH(5, 2, 6, HYDROGEN_JELLYFISH),
        NAGA(8, 3, 5, NAGA),
        FLYING_PIG(20, 2, 4, FLYING_PIG),
        JUNGLE_SKELETON(40, 2, 4, JUNGLE_SKELETON),
        PIGLIN_BRUTE(0, 1, 1, EntityType.PIGLIN_BRUTE);

        public final int weight;
        public final int minGroupSize;
        public final int maxGroupSize;
        public EntityType type;
        public BCLEntityWrapper wrapper;

        public boolean isVanilla() {
            return this.wrapper == null;
        }

        public void addSpawn(NetherBiomeBuilder builder, NetherBiomeConfig data) {
            int weight = data.spawnWeight(this);
            if (weight <= 0 || this.maxGroupSize <= 0) {
                return;
            }
            if (this.wrapper == null) {
                builder.spawn(this.type, weight, this.minGroupSize, this.maxGroupSize);
            } else if (this.wrapper.canSpawn()) {
                builder.spawn(this.wrapper.type(), weight, this.minGroupSize, this.maxGroupSize);
            }
        }

        private KnownSpawnTypes(int w, int min, int max, EntityType type) {
            this.weight = w;
            this.minGroupSize = min;
            this.maxGroupSize = max;
            this.type = type;
            this.wrapper = null;
        }

        private <M extends Mob> KnownSpawnTypes(int w, int min, int max, BCLEntityWrapper type) {
            this.weight = w;
            this.minGroupSize = min;
            this.maxGroupSize = max;
            this.type = type == null ? null : type.type();
            this.wrapper = type;
        }

        void setWrapper(BCLEntityWrapper wrapper) {
            this.wrapper = wrapper;
            if (wrapper != null) {
                this.type = wrapper.type();
            }
        }
    }
}

