/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.betterx.betternether.BN;
import org.betterx.betternether.registry.features.placed.NetherOresPlaced;
import org.betterx.betternether.world.biomes.util.NetherBiomeBuilder;
import org.betterx.betternether.world.features.AnchorTreeBranchFeature;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.features.AnchorTreeRootFeature;
import org.betterx.betternether.world.features.BigBrownMushroomFeature;
import org.betterx.betternether.world.features.CavesFeature;
import org.betterx.betternether.world.features.CrystalFeature;
import org.betterx.betternether.world.features.JellyfishMushroomFeature;
import org.betterx.betternether.world.features.LucisFeature;
import org.betterx.betternether.world.features.MushroomFirFeature;
import org.betterx.betternether.world.features.NetherSakuraBushFeature;
import org.betterx.betternether.world.features.NetherSakuraFeature;
import org.betterx.betternether.world.features.OldWillowTree;
import org.betterx.betternether.world.features.PathsFeature;
import org.betterx.betternether.world.features.RubeusBushFeature;
import org.betterx.betternether.world.features.RubeusTreeFeature;
import org.betterx.betternether.world.features.SoulLilyFeature;
import org.betterx.betternether.world.features.TwistedVinesFeature;
import org.betterx.betternether.world.features.WartBushFeature;
import org.betterx.betternether.world.features.WartCapFeature;
import org.betterx.betternether.world.features.WartTreeFeature;
import org.betterx.betternether.world.features.WillowBushFeature;
import org.betterx.betternether.world.features.WillowTreeFeature;
import org.betterx.betternether.world.structures.city.CityStructure;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnServerLevelReady;
import org.betterx.wover.feature.api.FeatureManager;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;

public class NetherFeatures {
    public static Feature<NoneFeatureConfiguration> JELLYFISH_MUSHROOM;
    public static Feature<NoneFeatureConfiguration> OBSIDIAN_CRYSTAL;
    public static Feature<NoneFeatureConfiguration> WART_BUSH;
    public static RubeusTreeFeature RUBEUS_TREE;
    public static MushroomFirFeature MUSHROOM_FIR;
    public static BigBrownMushroomFeature BIG_BROWN_MUSHROOM;
    public static Feature<NoneFeatureConfiguration> RUBEUS_BUSH;
    public static Feature<NoneFeatureConfiguration> LUCIS;
    public static SoulLilyFeature SOUL_LILY;
    public static WartTreeFeature WART_TREE;
    public static WillowBushFeature WILLOW_BUSH;
    public static WillowTreeFeature WILLOW_TREE;
    public static OldWillowTree OLD_WILLOW_TREE;
    public static NetherSakuraFeature SAKURA_TREE;
    public static NetherSakuraBushFeature SAKURA_BUSH;
    public static AnchorTreeBranchFeature ANCHOR_TREE_BRANCH;
    public static AnchorTreeFeature ANCHOR_TREE;
    public static AnchorTreeRootFeature ANCHOR_TREE_ROOT;
    public static WartCapFeature WART_CAP;
    public static TwistedVinesFeature TWISTING_VINES;
    private static boolean registered;

    public static NetherBiomeBuilder addDefaultFeatures(NetherBiomeBuilder builder) {
        return builder;
    }

    public static void addDefaultBNFeatures(NetherBiomeBuilder builder) {
    }

    public static NetherBiomeBuilder addDefaultOres(NetherBiomeBuilder builder) {
        return (NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)builder.feature((BasePlacedFeatureKey)NetherOresPlaced.CINCINNASITE_ORE)).feature((BasePlacedFeatureKey)NetherOresPlaced.NETHER_RUBY_ORE_RARE)).feature((BasePlacedFeatureKey)NetherOresPlaced.NETHER_LAPIS_ORE)).feature((BasePlacedFeatureKey)NetherOresPlaced.NETHER_REDSTONE_ORE);
    }

    public static void onRegister(RegisterEvent event) {
        if (!event.getRegistryKey().equals(Registries.FEATURE)) {
            return;
        }
        NetherFeatures.register();
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        JELLYFISH_MUSHROOM = FeatureManager.register((ResourceLocation)BN.id("jellyfish_mushroom"), (Feature)new JellyfishMushroomFeature());
        OBSIDIAN_CRYSTAL = FeatureManager.register((ResourceLocation)BN.id("obsidian_crystal"), (Feature)new CrystalFeature());
        WART_BUSH = FeatureManager.register((ResourceLocation)BN.id("wart_bush"), (Feature)new WartBushFeature());
        RUBEUS_TREE = (RubeusTreeFeature)FeatureManager.register((ResourceLocation)BN.id("rubeus_tree"), (Feature)new RubeusTreeFeature());
        MUSHROOM_FIR = (MushroomFirFeature)FeatureManager.register((ResourceLocation)BN.id("mushroom_fir"), (Feature)new MushroomFirFeature());
        BIG_BROWN_MUSHROOM = (BigBrownMushroomFeature)FeatureManager.register((ResourceLocation)BN.id("big_brown_mushroom"), (Feature)new BigBrownMushroomFeature());
        RUBEUS_BUSH = FeatureManager.register((ResourceLocation)BN.id("rubeus_bush"), (Feature)new RubeusBushFeature());
        LUCIS = FeatureManager.register((ResourceLocation)BN.id("lucis"), (Feature)new LucisFeature());
        SOUL_LILY = (SoulLilyFeature)FeatureManager.register((ResourceLocation)BN.id("soul_lily"), (Feature)new SoulLilyFeature());
        WART_TREE = (WartTreeFeature)FeatureManager.register((ResourceLocation)BN.id("wart_tree"), (Feature)new WartTreeFeature());
        WILLOW_BUSH = (WillowBushFeature)FeatureManager.register((ResourceLocation)BN.id("willow_bush"), (Feature)new WillowBushFeature());
        WILLOW_TREE = (WillowTreeFeature)FeatureManager.register((ResourceLocation)BN.id("willow_tree"), (Feature)new WillowTreeFeature());
        OLD_WILLOW_TREE = (OldWillowTree)FeatureManager.register((ResourceLocation)BN.id("old_willow_tree"), (Feature)new OldWillowTree());
        SAKURA_TREE = (NetherSakuraFeature)FeatureManager.register((ResourceLocation)BN.id("sakura_tree"), (Feature)new NetherSakuraFeature());
        SAKURA_BUSH = (NetherSakuraBushFeature)FeatureManager.register((ResourceLocation)BN.id("sakura_bush"), (Feature)new NetherSakuraBushFeature());
        ANCHOR_TREE_BRANCH = (AnchorTreeBranchFeature)FeatureManager.register((ResourceLocation)BN.id("anchor_tree_branch"), (Feature)new AnchorTreeBranchFeature());
        ANCHOR_TREE = (AnchorTreeFeature)FeatureManager.register((ResourceLocation)BN.id("anchor_tree"), (Feature)new AnchorTreeFeature());
        ANCHOR_TREE_ROOT = (AnchorTreeRootFeature)FeatureManager.register((ResourceLocation)BN.id("anchor_tree_root"), (Feature)new AnchorTreeRootFeature());
        WART_CAP = (WartCapFeature)FeatureManager.register((ResourceLocation)BN.id("wart_cap"), (Feature)new WartCapFeature());
        TWISTING_VINES = (TwistedVinesFeature)FeatureManager.register((ResourceLocation)BN.id("twisting_vines"), (Feature)new TwistedVinesFeature());
        WorldLifecycle.SERVER_LEVEL_READY.subscribe((Subscriber)((OnServerLevelReady)NetherFeatures::onWorldLoad));
    }

    private static void onWorldLoad(ServerLevel level, ResourceKey<Level> levelResourceKey, LevelStem levelStem, long seed) {
        if (levelResourceKey.equals((Object)Level.NETHER)) {
            CavesFeature.onLoad(seed);
            PathsFeature.onLoad(seed);
            CityStructure.initGenerator();
        }
    }

    static {
        registered = false;
    }
}

