/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry.features.configured;

import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v3.bonemeal.BonemealAPI;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.world.features.NetherSakuraBushFeature;
import org.betterx.betternether.world.features.WillowBushFeature;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.events.api.Subscriber;
import org.betterx.wover.events.api.WorldLifecycle;
import org.betterx.wover.events.api.types.OnServerLevelReady;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureKey;
import org.betterx.wover.feature.api.configured.ConfiguredFeatureManager;
import org.betterx.wover.feature.api.configured.configurators.AsBlockColumn;
import org.betterx.wover.feature.api.configured.configurators.AsMultiPlaceRandomSelect;
import org.betterx.wover.feature.api.configured.configurators.FacingBlock;
import org.betterx.wover.feature.api.configured.configurators.ForSimpleBlock;
import org.betterx.wover.feature.api.configured.configurators.NetherForrestVegetation;
import org.betterx.wover.feature.api.configured.configurators.RandomPatch;
import org.betterx.wover.feature.api.configured.configurators.WeightedBlock;
import org.betterx.wover.feature.api.configured.configurators.WeightedBlockPatch;
import org.betterx.wover.feature.api.configured.configurators.WithConfiguration;
import org.betterx.wover.state.api.WorldState;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class NetherVegetation {
    private static final ModCore C = BetterNether.C;
    public static final ConfiguredFeatureKey<WeightedBlockPatch> BONEMEAL_NETHERRACK_MOSS;
    public static final ConfiguredFeatureKey<WeightedBlockPatch> BONEMEAL_NETHER_MYCELIUM;
    public static final ConfiguredFeatureKey<WeightedBlockPatch> BONEMEAL_JUNGLE_GRASS;
    public static final ConfiguredFeatureKey<NetherForrestVegetation> BONEMEAL_MUSHROOM_GRASS;
    public static final ConfiguredFeatureKey<NetherForrestVegetation> BONEMEAL_SEPIA_MUSHROOM_GRASS;
    public static final ConfiguredFeatureKey<WeightedBlockPatch> BONEMEAL_SWAMPLAND_GRASS;
    public static final ConfiguredFeatureKey<WeightedBlockPatch> BONEMEAL_CEILING_MUSHROOMS;
    public static final ConfiguredFeatureKey<AsMultiPlaceRandomSelect> VEGETATION_MUSHROOM_FORREST;
    public static final ConfiguredFeatureKey<WithConfiguration<Feature<NoneFeatureConfiguration>, NoneFeatureConfiguration>> JELLYFISH_MUSHROOM;
    public static final ConfiguredFeatureKey<RandomPatch> PATCH_JELLYFISH_MUSHROOM;
    public static final ConfiguredFeatureKey<ForSimpleBlock> PATCH_BLACK_BUSH;
    public static final ConfiguredFeatureKey<WithConfiguration<Feature<NoneFeatureConfiguration>, NoneFeatureConfiguration>> WALL_LUCIS;
    public static final ConfiguredFeatureKey<WeightedBlockPatch> BONEMEAL_SOUL_SOIL;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_MAGMA_LAND;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_GRASSLANDS;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_GRAVEL_DESERT;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_JUNGLE;
    public static final ConfiguredFeatureKey<AsMultiPlaceRandomSelect> VEGETATION_POOR_GRASSLANDS;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_SOUL_PLAIN;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_WART_FOREST;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_WART_FOREST_EDGE;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_SWAMPLAND;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_OLD_SWAMPLAND;
    public static final ConfiguredFeatureKey<WeightedBlock> VEGETATION_OLD_WARPED_WOODS;
    public static final ConfiguredFeatureKey<AsBlockColumn> NETHER_CACTUS;
    public static final ConfiguredFeatureKey<FacingBlock> WALL_MUSHROOM_RED_WITH_MOSS;
    public static final ConfiguredFeatureKey<FacingBlock> WALL_MUSHROOMS_WITH_MOSS;
    public static final ConfiguredFeatureKey<FacingBlock> WALL_MUSHROOMS;
    public static final ConfiguredFeatureKey<FacingBlock> WALL_JUNGLE;
    public static final ConfiguredFeatureKey<FacingBlock> WALL_UPSIDE_DOWN;
    public static final ConfiguredFeatureKey<AsBlockColumn> NETHER_REED;
    public static final ConfiguredFeatureKey<WithConfiguration<Feature<NoneFeatureConfiguration>, NoneFeatureConfiguration>> WART_BUSH;
    public static final ConfiguredFeatureKey<WithConfiguration<WillowBushFeature, NoneFeatureConfiguration>> WILLOW_BUSH;
    public static final ConfiguredFeatureKey<WithConfiguration<Feature<NoneFeatureConfiguration>, NoneFeatureConfiguration>> RUBEUS_BUSH;
    public static final ConfiguredFeatureKey<WithConfiguration<NetherSakuraBushFeature, NoneFeatureConfiguration>> SAKURA_BUSH;
    public static final ConfiguredFeatureKey<WeightedBlock> SCULK_VEGETATION;
    public static final ConfiguredFeatureKey<ForSimpleBlock> HOOK_MUSHROOM;
    public static final ConfiguredFeatureKey<ForSimpleBlock> MOSS_COVER;
    private static final TagKey<Block> TERRAIN_TAG;
    private static final TagKey<Block> NETHERRACK_TAG;
    private static boolean bonemealSetupDone;
    private static boolean terrainTagLogged;

    public static void registerLifecycleHook() {
        WorldLifecycle.SERVER_LEVEL_READY.subscribe((Subscriber)((OnServerLevelReady)(level, key, stem, seed) -> {
            NetherVegetation.setupBonemealFeatures();
            NetherVegetation.logSurfaceTags(level);
        }));
    }

    public static void setupBonemealFeatures() {
        if (bonemealSetupDone) {
            return;
        }
        bonemealSetupDone = true;
        NetherBlocks.NETHERRACK_MOSS.setVegetationFeature(() -> BONEMEAL_NETHERRACK_MOSS.getHolder(WorldState.registryAccess()));
        NetherBlocks.NETHER_MYCELIUM.setVegetationFeature(() -> BONEMEAL_NETHER_MYCELIUM.getHolder(WorldState.registryAccess()));
        NetherBlocks.JUNGLE_GRASS.setVegetationFeature(() -> BONEMEAL_JUNGLE_GRASS.getHolder(WorldState.registryAccess()));
        NetherBlocks.MUSHROOM_GRASS.setVegetationFeature(() -> BONEMEAL_MUSHROOM_GRASS.getHolder(WorldState.registryAccess()));
        NetherBlocks.SEPIA_MUSHROOM_GRASS.setVegetationFeature(() -> BONEMEAL_SEPIA_MUSHROOM_GRASS.getHolder(WorldState.registryAccess()));
        NetherBlocks.SWAMPLAND_GRASS.setVegetationFeature(() -> BONEMEAL_SWAMPLAND_GRASS.getHolder(WorldState.registryAccess()));
        NetherBlocks.CEILING_MUSHROOMS.setVegetationFeature(() -> BONEMEAL_CEILING_MUSHROOMS.getHolder(WorldState.registryAccess()));
        BonemealAPI.INSTANCE.addSpreadableFeatures(Blocks.SOUL_SOIL, () -> BONEMEAL_SOUL_SOIL.getHolder(WorldState.registryAccess()));
        BonemealAPI.INSTANCE.addSpreadableFeatures(Blocks.SOUL_SAND, () -> BONEMEAL_SOUL_SOIL.getHolder(WorldState.registryAccess()));
    }

    private static void logSurfaceTags(ServerLevel level) {
        if (terrainTagLogged) {
            return;
        }
        terrainTagLogged = true;
        Registry registry = level.registryAccess().registryOrThrow(Registries.BLOCK);
        NetherVegetation.logSurfaceTag((Registry<Block>)registry, TERRAIN_TAG, "wover:surfaces/nether/terrain");
        NetherVegetation.logSurfaceTag((Registry<Block>)registry, NETHERRACK_TAG, "wover:surfaces/nether/netherrack");
        NetherVegetation.logSurfaceTag((Registry<Block>)registry, (TagKey<Block>)CommonBlockTags.NETHER_STONES, "wover:surfaces/nether/stones");
        NetherVegetation.logSurfaceTag((Registry<Block>)registry, (TagKey<Block>)BlockTags.NYLIUM, "minecraft:nylium");
    }

    private static void logSurfaceTag(Registry<Block> registry, TagKey<Block> tagKey, String label) {
        Optional tag = registry.getTag(tagKey);
        if (tag.isEmpty()) {
            BetterNether.C.LOG.warn("Missing block tag {} for vegetation placement checks.", new Object[]{label});
            return;
        }
        HolderSet.Named entries = (HolderSet.Named)tag.get();
        boolean hasJungleGrass = entries.stream().anyMatch(holder -> holder.value() == NetherBlocks.JUNGLE_GRASS);
        BetterNether.C.LOG.info("Block tag {} size={}, has betternether:jungle_grass={}", new Object[]{label, entries.size(), hasJungleGrass});
    }

    static {
        NetherFeatures.register();
        BONEMEAL_NETHERRACK_MOSS = ConfiguredFeatureManager.bonemeal((ResourceLocation)C.id("bonemeal_netherrack_moss"));
        BONEMEAL_NETHER_MYCELIUM = ConfiguredFeatureManager.bonemeal((ResourceLocation)C.id("bonemeal_nether_mycelium"));
        BONEMEAL_JUNGLE_GRASS = ConfiguredFeatureManager.bonemeal((ResourceLocation)C.id("bonemeal_jungle_grass"));
        BONEMEAL_MUSHROOM_GRASS = ConfiguredFeatureManager.bonemealNetherForrest((ResourceLocation)C.id("bonemeal_mushroom_grass"));
        BONEMEAL_SEPIA_MUSHROOM_GRASS = ConfiguredFeatureManager.bonemealNetherForrest((ResourceLocation)C.id("bonemeal_sepia_mushroom_grass"));
        BONEMEAL_SWAMPLAND_GRASS = ConfiguredFeatureManager.bonemeal((ResourceLocation)C.id("bonemeal_swampland_grass"));
        BONEMEAL_CEILING_MUSHROOMS = ConfiguredFeatureManager.bonemeal((ResourceLocation)C.id("bonemeal_ceiling_mushrooms"));
        VEGETATION_MUSHROOM_FORREST = ConfiguredFeatureManager.multiPlaceRandomFeature((ResourceLocation)C.id("vegetation_mushroom_forrest"));
        JELLYFISH_MUSHROOM = ConfiguredFeatureManager.configuration((ResourceLocation)C.id("jellyfish_mushroom"), NetherFeatures.JELLYFISH_MUSHROOM);
        PATCH_JELLYFISH_MUSHROOM = ConfiguredFeatureManager.randomPatch((ResourceLocation)C.id("patch_jellyfish_mushroom"));
        PATCH_BLACK_BUSH = ConfiguredFeatureManager.simple((ResourceLocation)C.id("patch_back_bush"));
        WALL_LUCIS = ConfiguredFeatureManager.configuration((ResourceLocation)C.id("patch_lucis"), NetherFeatures.LUCIS);
        BONEMEAL_SOUL_SOIL = ConfiguredFeatureManager.bonemeal((ResourceLocation)C.id("bonemeal_soul_soil"));
        VEGETATION_MAGMA_LAND = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_magma_land"));
        VEGETATION_GRASSLANDS = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_nether_grasslands"));
        VEGETATION_GRAVEL_DESERT = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_nether_gravel_desert"));
        VEGETATION_JUNGLE = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_jungle"));
        VEGETATION_POOR_GRASSLANDS = ConfiguredFeatureManager.multiPlaceRandomFeature((ResourceLocation)C.id("vegetation_nether_poor_grasslands"));
        VEGETATION_SOUL_PLAIN = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_soul_plain"));
        VEGETATION_WART_FOREST = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_wart_forest"));
        VEGETATION_WART_FOREST_EDGE = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_wart_forest_edge"));
        VEGETATION_SWAMPLAND = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_nether_swampland"));
        VEGETATION_OLD_SWAMPLAND = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_old_swampland"));
        VEGETATION_OLD_WARPED_WOODS = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("vegetation_old_warped_woods"));
        NETHER_CACTUS = ConfiguredFeatureManager.blockColumn((ResourceLocation)C.id("patch_nether_cactus"));
        WALL_MUSHROOM_RED_WITH_MOSS = ConfiguredFeatureManager.facingBlock((ResourceLocation)C.id("patch_wall_mushroom_red_with_moss"));
        WALL_MUSHROOMS_WITH_MOSS = ConfiguredFeatureManager.facingBlock((ResourceLocation)C.id("patch_wall_mushrooms_with_moss"));
        WALL_MUSHROOMS = ConfiguredFeatureManager.facingBlock((ResourceLocation)C.id("patch_wall_mushrooms"));
        WALL_JUNGLE = ConfiguredFeatureManager.facingBlock((ResourceLocation)C.id("patch_wall_jungle"));
        WALL_UPSIDE_DOWN = ConfiguredFeatureManager.facingBlock((ResourceLocation)C.id("patch_upside_down"));
        NETHER_REED = ConfiguredFeatureManager.blockColumn((ResourceLocation)C.id("patch_nether_reed"));
        WART_BUSH = ConfiguredFeatureManager.configuration((ResourceLocation)C.id("patch_wart_bush"), NetherFeatures.WART_BUSH);
        WILLOW_BUSH = ConfiguredFeatureManager.configuration((ResourceLocation)C.id("patch_willow_bush"), (Feature)NetherFeatures.WILLOW_BUSH);
        RUBEUS_BUSH = ConfiguredFeatureManager.configuration((ResourceLocation)C.id("patch_rubeus_bush"), NetherFeatures.RUBEUS_BUSH);
        SAKURA_BUSH = ConfiguredFeatureManager.configuration((ResourceLocation)C.id("patch_sakura_bush"), (Feature)NetherFeatures.SAKURA_BUSH);
        SCULK_VEGETATION = ConfiguredFeatureManager.randomBlock((ResourceLocation)C.id("sculk_vegetation"));
        HOOK_MUSHROOM = ConfiguredFeatureManager.simple((ResourceLocation)C.id("patch_hook_mushroom"));
        MOSS_COVER = ConfiguredFeatureManager.simple((ResourceLocation)C.id("patch_moss_cover"));
        TERRAIN_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wover", (String)"surfaces/nether/terrain"));
        NETHERRACK_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"wover", (String)"surfaces/nether/netherrack"));
        bonemealSetupDone = false;
        terrainTagLogged = false;
    }
}

