/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.biomes.util;

import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.betternether.world.biomes.util.NetherBiomeKey;
import org.betterx.wover.biome.api.BiomeKey;
import org.betterx.wover.biome.api.builder.BiomeBootstrapContext;
import org.betterx.wover.biome.api.builder.BiomeBuilder;
import org.betterx.wover.biome.api.builder.BiomeSurfaceRuleBuilder;
import org.betterx.wover.biome.api.data.BiomeData;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.generator.api.biomesource.WoverBiomeBuilder;
import org.betterx.wover.structure.api.StructureKey;
import org.jetbrains.annotations.NotNull;

public class NetherBiomeBuilder
extends WoverBiomeBuilder.AbstractWoverBiomeBuilder<NetherBiomeBuilder> {
    public static final SurfaceRules.RuleSource BEDROCK = SurfaceRules.state((BlockState)Blocks.BEDROCK.defaultBlockState());
    public static final SurfaceRules.ConditionSource BEDROCK_BOTTOM = SurfaceRules.verticalGradient((String)BetterNether.C.id("bedrock_floor").toString(), (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5));
    public static final SurfaceRules.ConditionSource BEDROCK_TOP = SurfaceRules.verticalGradient((String)BetterNether.C.id("bedrock_roof").toString(), (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.top());

    protected NetherBiomeBuilder(BiomeBootstrapContext context, BiomeKey<NetherBiomeBuilder> key) {
        super(context, key);
        ((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)this.tag(new TagKey[]{NetherTags.BETTER_NETHER})).temperature(BiomeBuilder.DEFAULT_NETHER_TEMPERATURE)).downfall(BiomeBuilder.DEFAULT_NETHER_WETNESS)).hasPrecipitation(false)).waterColor(BiomeBuilder.DEFAULT_NETHER_WATER_COLOR)).waterFogColor(BiomeBuilder.DEFAULT_NETHER_WATER_FOG_COLOR)).skyColor(BiomeBuilder.calculateSkyColor((float)BiomeBuilder.DEFAULT_NETHER_TEMPERATURE))).music((Holder)SoundEvents.MUSIC_BIOME_NETHER_WASTES)).mood((Holder)SoundEvents.AMBIENT_NETHER_WASTES_MOOD)).loop((Holder)SoundEvents.AMBIENT_NETHER_WASTES_LOOP)).additions((Holder)SoundEvents.AMBIENT_NETHER_WASTES_ADDITIONS)).isNetherBiome()).feature((BasePlacedFeatureKey)NetherVegetationPlaced.WART_CAP);
    }

    private void addVanillaStructures() {
        ((NetherBiomeBuilder)this.carver(GenerationStep.Carving.AIR, Carvers.NETHER_CAVE)).structure(BiomeTags.HAS_RUINED_PORTAL_NETHER);
    }

    private void addVanillaFeatures() {
        ((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)((NetherBiomeBuilder)this.feature(GenerationStep.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.SPRING_LAVA)).defaultMushrooms()).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_OPEN)).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_FIRE)).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.PATCH_SOUL_FIRE)).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE_EXTRA)).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.GLOWSTONE)).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, VegetationPlacements.BROWN_MUSHROOM_NETHER)).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, VegetationPlacements.RED_MUSHROOM_NETHER)).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.ORE_MAGMA)).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.SPRING_CLOSED);
    }

    private void addBNStructures() {
        ((NetherBiomeBuilder)((NetherBiomeBuilder)this.structure((StructureKey)NetherStructures.PYRAMIDS)).structure((StructureKey)NetherStructures.GHAST_HIVE)).structure(NetherTags.BETTER_NETHER_DECORATIONS);
    }

    NetherBiomeBuilder configure(NetherBiomeConfig config) {
        BiomeSurfaceRuleBuilder surfaceBuilder = this.startSurface();
        config.surface((BiomeSurfaceRuleBuilder<NetherBiomeBuilder>)surfaceBuilder);
        surfaceBuilder.finishSurface();
        ResourceKey<Biome> otherBiome = config.subBiomeOf();
        if (otherBiome != null) {
            this.parent(otherBiome);
        }
        if ((otherBiome = config.withEdgeBiome()) != null) {
            this.edge(otherBiome);
        }
        if (config.hasVanillaStructures()) {
            this.addVanillaStructures();
        }
        if (config.hasBNStructures()) {
            this.addBNStructures();
        }
        if (config.hasVanillaFeatures()) {
            this.addVanillaFeatures();
        }
        if (config.hasVanillaOres()) {
            this.netherDefaultOres();
        }
        if (config.hasBNFeatures()) {
            NetherFeatures.addDefaultBNFeatures(this);
        }
        for (NetherEntities.KnownSpawnTypes spawnType : NetherEntities.KnownSpawnTypes.values()) {
            spawnType.addSpawn(this, config);
        }
        NetherFeatures.addDefaultFeatures(this);
        if (config.hasDefaultOres()) {
            NetherFeatures.addDefaultOres(this);
        }
        if (config.hasNetherCity()) {
            this.structure((StructureKey)NetherStructures.CITY_STRUCTURE);
        }
        config.addCustomBuildData(this);
        return this;
    }

    public static <C extends NetherBiomeConfig> NetherBiomeKey<C> createKey(@NotNull String name) {
        return new NetherBiomeKey(BetterNether.C.id(name.replace(' ', '_').toLowerCase()));
    }

    public void registerBiomeData(BootstrapContext<BiomeData> dataContext) {
        dataContext.register(this.key.dataKey, (Object)new NetherBiome(this.fogDensity, (ResourceKey<Biome>)this.key.key, new BiomeGenerationDataContainer(this.parameters, this.intendedPlacement), this.terrainHeight, this.genChance, this.edgeSize, this.vertical, (ResourceKey<Biome>)this.edge, (ResourceKey<Biome>)this.parent));
    }
}

