/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockAnchorTreeVine;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class AnchorTreeBranchFeature
extends ContextFeature<NoneFeatureConfiguration>
implements GrowableFeature<NoneFeatureConfiguration> {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{-20.0f, -17.0f, -12.0f, -4.0f, 0.0f, 2.0f};
    private static final int MIDDLE_Y = 10;

    public AnchorTreeBranchFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        if (pos.getY() < 56 + random.nextInt((int)(20.0f * scale_factor))) {
            return false;
        }
        return this.grow(world, pos, random, scale_factor, context);
    }

    private boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, float scale_factor, StructureGeneratorThreadContext context) {
        int i;
        context.clear();
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        BlockState leaves = (BlockState)NetherBlocks.ANCHOR_TREE_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN, Direction.UP};
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize * scale_factor;
            int x1 = Math.round((float)pos.getX() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.getY() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.getZ() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 9.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((LevelAccessor)world, new BlockPos(x1, y1 + 1, z1), crownR, random, scale_factor, context);
            int middle = Math.round((float)pos.getY() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.getX() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.getY() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.getZ() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] >= 0.0f && this.canReplace(world.getBlockState((BlockPos)context.POS.set(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (this.canReplace(world.getBlockState((BlockPos)context.POS.set(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.getX();
                        y2 = pos.getY();
                        generate = false;
                    }
                }
                this.line((LevelAccessor)world, x1, y1, z1, x2, y2, z2, middle, context);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<BlockPos> iterator = context.TOP.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos == null || !context.POINTS.contains(bpos.above()) || context.TOP.contains(bpos.above())) continue;
            iterator.remove();
        }
        iterator = context.MIDDLE.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos != null) {
                BlockPos up = bpos.above();
                if (!context.MIDDLE.contains(up) && (context.TOP.contains(up) || !context.POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (BlockPos bpos : context.POINTS) {
            BlockState state = context.POINTS.contains(bpos.above()) && context.POINTS.contains(bpos.below()) ? NetherBlocks.MAT_ANCHOR_TREE.getLog().defaultBlockState() : NetherBlocks.MAT_ANCHOR_TREE.getBark().defaultBlockState();
            BlocksHelper.setWithUpdate((LevelAccessor)world, bpos, state);
            boolean hasLeavesOnLevel = false;
            for (Direction d : directions) {
                BlockState currentState;
                if (!hasLeavesOnLevel && d == Direction.DOWN) continue;
                int max = 0;
                for (i = 1; i <= 7; ++i) {
                    context.POS.setWithOffset((Vec3i)bpos, d.getStepX() * i, d.getStepY() * i, d.getStepZ() * i);
                    currentState = world.getBlockState((BlockPos)context.POS);
                    if (!currentState.hasProperty((Property)BlockStateProperties.DISTANCE)) continue;
                    max = i;
                }
                if (d != Direction.DOWN && d != Direction.UP) {
                    hasLeavesOnLevel |= max > 0;
                }
                for (i = 1; i < max; ++i) {
                    context.POS.setWithOffset((Vec3i)bpos, d.getStepX() * i, d.getStepY() * i, d.getStepZ() * i);
                    currentState = world.getBlockState((BlockPos)context.POS);
                    if (!currentState.is(NetherBlocks.ANCHOR_TREE_VINE) && !currentState.is(Blocks.AIR)) continue;
                    BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, leaves);
                    BlockPos vpos = context.POS.above();
                    currentState = world.getBlockState(vpos);
                    while (currentState.is(NetherBlocks.ANCHOR_TREE_VINE)) {
                        AnchorTreeBranchFeature.safeSet((LevelAccessor)world, vpos, leaves);
                        vpos = vpos.above();
                        currentState = world.getBlockState(vpos);
                    }
                }
            }
            this.updateSDFFrom(bpos, context);
        }
        context.clear();
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        return true;
    }

    public static void safeSet(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!state.is(Blocks.BEDROCK)) {
            BlocksHelper.setWithoutUpdate(level, pos, state);
        }
    }

    private void updateDistances(ServerLevelAccessor world, StructureGeneratorThreadContext context) {
        for (Map.Entry<BlockPos, Byte> entry : context.LOGS_DIST.entrySet()) {
            byte dist = entry.getValue();
            BlockPos logPos = entry.getKey();
            BlockState currentState = world.getBlockState(logPos);
            if (!currentState.hasProperty((Property)BlockStateProperties.DISTANCE)) continue;
            int cDist = (Integer)currentState.getValue((Property)BlockStateProperties.DISTANCE);
            if (dist < cDist) {
                AnchorTreeBranchFeature.safeSet((LevelAccessor)world, logPos, (BlockState)currentState.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(dist)));
                cDist = dist;
            }
            if (cDist < 7) continue;
            AnchorTreeBranchFeature.safeSet((LevelAccessor)world, logPos, Blocks.AIR.defaultBlockState());
            BlockPos pos = logPos.below();
            currentState = world.getBlockState(pos);
            while (currentState.is(NetherBlocks.ANCHOR_TREE_VINE)) {
                AnchorTreeBranchFeature.safeSet((LevelAccessor)world, pos, Blocks.AIR.defaultBlockState());
                pos = pos.below();
                currentState = world.getBlockState(pos);
            }
        }
    }

    private void updateSDFFrom(BlockPos bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    int dist;
                    if (x == 0 && y == 0 && z == 0 || (dist = Math.abs(x) + Math.abs(y) + Math.abs(z)) > 7) continue;
                    BlockPos blPos = bpos.offset(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void line(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, int middleY, StructureGeneratorThreadContext context) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = context.POS.set(x1, y1, z1).immutable();
        context.POINTS.add(pos);
        if (pos.getY() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.getY() > middleY) {
            context.TOP.add(pos);
        }
        pos = context.POS.set(x2, y2, z2).immutable();
        context.POINTS.add(pos);
        if (pos.getY() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.getY() > middleY) {
            context.TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            context.POS.set(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = context.POS.immutable();
            context.POINTS.add(pos);
            if (context.POS.getY() == middleY) {
                context.MIDDLE.add(pos);
                continue;
            }
            if (context.POS.getY() <= middleY) continue;
            context.TOP.add(pos);
        }
    }

    private void crown(LevelAccessor world, BlockPos pos, float radius, RandomSource random, float scale_factor, StructureGeneratorThreadContext context) {
        scale_factor = (scale_factor - 1.0f) * 0.25f + 1.0f;
        float rnd = MHelper.nextFloat(random, 5.0f * scale_factor);
        int HEIGHT_10 = (int)(10.0f * scale_factor + rnd);
        int HEIGHT_15 = (int)(15.0f * scale_factor + rnd);
        int HEIGHT_17 = (int)(17.0f * scale_factor + rnd);
        BlockState leaves = NetherBlocks.ANCHOR_TREE_LEAVES.defaultBlockState();
        BlockState vine = NetherBlocks.ANCHOR_TREE_VINE.defaultBlockState();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int start = (int)Math.floor(-radius);
        for (int cy = (int)Math.floor(radius); cy >= start; --cy) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            context.POS.setY((int)((float)(pos.getY() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                context.POS.setX(pos.getX() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        context.POS.setZ(pos.getZ() + cz);
                        if (world.getBlockState((BlockPos)context.POS).canBeReplaced()) {
                            int length = BlocksHelper.downRay(world, (BlockPos)context.POS, HEIGHT_17);
                            if (length < 5) {
                                AnchorTreeBranchFeature.safeSet(world, (BlockPos)context.POS, leaves);
                            } else {
                                if (length > HEIGHT_15) {
                                    length = MHelper.randRange(HEIGHT_10, HEIGHT_15, random);
                                } else if (length > HEIGHT_10) {
                                    length = MHelper.randRange(HEIGHT_10, length, random);
                                }
                                if (cz % 2 == cx % 2) {
                                    length /= 3;
                                }
                                if (length > 4) {
                                    for (int i = 1; i < length - 2; ++i) {
                                        AnchorTreeBranchFeature.safeSet(world, context.POS.below(i), vine);
                                    }
                                    AnchorTreeBranchFeature.safeSet(world, context.POS.below(length - 2), (BlockState)vine.setValue(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
                                    AnchorTreeBranchFeature.safeSet(world, context.POS.below(length - 1), (BlockState)vine.setValue(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
                                }
                                AnchorTreeBranchFeature.safeSet(world, (BlockPos)context.POS, leaves);
                            }
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
        }
    }

    private boolean canReplace(BlockState state) {
        return BlocksHelper.isNetherGround(state) || state.canBeReplaced();
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration cfg) {
        return this.grow(level, pos, random, 1.0f, NetherThreadDataStorage.generatorForThread().context);
    }
}

