/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockAnchorTreeVine;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.LucisFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.block.api.BlockProperties;

public class AnchorTreeRootFeature
extends ContextFeature<NoneFeatureConfiguration> {
    private static final LucisFeature LUCIS = new LucisFeature();

    public AnchorTreeRootFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if ((double)pos.getY() < (double)MAX_HEIGHT * 0.75) {
            return false;
        }
        double angle = random.nextDouble() * Math.PI * 2.0;
        double dx = Math.sin(angle);
        double dz = Math.cos(angle);
        double size = (double)MHelper.randRange(10, 25, random) * 0.5;
        int count = MHelper.floor(size * 2.0);
        if (count < 3) {
            count = 3;
        }
        if ((count & 1) == 0) {
            ++count;
        }
        context.POS.set((double)pos.getX() - dx * size, (double)(pos.getY() + 10), (double)pos.getZ() - dz * size);
        BlockPos start = context.POS.above(BlocksHelper.upRay((LevelAccessor)world, (BlockPos)context.POS, (int)((double)MAX_HEIGHT * 0.75)));
        if (start.getY() < pos.getY()) {
            start = context.POS.set((Vec3i)start).offset(0, 10, 0).immutable();
        }
        context.POS.set((double)pos.getX() + dx * size, (double)(pos.getY() + 10), (double)pos.getZ() + dz * size);
        BlockPos end = context.POS.above(BlocksHelper.upRay((LevelAccessor)world, (BlockPos)context.POS, (int)((double)MAX_HEIGHT * 0.75)));
        if (end.getY() < pos.getY()) {
            end = context.POS.set((Vec3i)end).offset(0, 10, 0).immutable();
        }
        List<BlockPos> blocks = this.lineParable(start, end, count, random, 0.2);
        context.BLOCKS.clear();
        this.buildLine(blocks, 1.3 + random.nextDouble(), context);
        BlockState vine = NetherBlocks.ANCHOR_TREE_VINE.defaultBlockState();
        int minBuildHeight = world.getMinBuildHeight() + 1;
        BoundingBox blockBox = BlocksHelper.decorationBounds((LevelAccessor)world, pos, minBuildHeight, MAX_HEIGHT - 2);
        for (BlockPos bpos : context.BLOCKS) {
            int length;
            BlockState state;
            if (bpos.getY() < minBuildHeight || bpos.getY() > MAX_HEIGHT - 2 || !BlocksHelper.isNetherGround(state = world.getBlockState(bpos)) && !this.canReplace(state)) continue;
            boolean blockDown = true;
            boolean blockUp = context.BLOCKS.contains(bpos.above());
            if (blockUp && (blockDown = context.BLOCKS.contains(bpos.below()))) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos, NetherBlocks.MAT_ANCHOR_TREE.getLog().defaultBlockState());
            } else {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos, NetherBlocks.MAT_ANCHOR_TREE.getBark().defaultBlockState());
            }
            if (!blockUp && world.getBlockState(bpos.above()).canBeReplaced()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos.above(), NetherBlocks.MOSS_COVER.defaultBlockState());
            }
            if ((bpos.getY() & 3) == 0 && AnchorTreeFeature.NOISE.eval((double)bpos.getX() * 0.1, (double)bpos.getY() * 0.1, (double)bpos.getZ() * 0.1) > 0.0) {
                if (random.nextInt(32) == 0 && !context.BLOCKS.contains(bpos.north())) {
                    if (random.nextBoolean()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.north(), random.nextDouble() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.nextInt(32) == 0 && !context.BLOCKS.contains(bpos.south())) {
                    if (random.nextBoolean()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.south(), random.nextDouble() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.nextInt(32) == 0 && !context.BLOCKS.contains(bpos.east())) {
                    if (random.nextBoolean()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.east(), random.nextDouble() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.nextInt(32) == 0 && !context.BLOCKS.contains(bpos.west())) {
                    if (random.nextBoolean()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.west(), random.nextDouble() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
            }
            Block[] wallPlants = AnchorTreeFeature.wallPlants();
            state = wallPlants[random.nextInt(wallPlants.length)].defaultBlockState();
            BlockPos _pos = bpos.north();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && world.isEmptyBlock(_pos)) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            _pos = bpos.south();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && world.isEmptyBlock(_pos)) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            _pos = bpos.east();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && world.isEmptyBlock(_pos)) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            _pos = bpos.west();
            if (random.nextInt(8) == 0 && !context.BLOCKS.contains(_pos) && world.isEmptyBlock(_pos)) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, _pos, (BlockState)state.setValue((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
            }
            if (!blockUp || blockDown || random.nextInt(16) != 0 || (length = BlocksHelper.downRay((LevelAccessor)world, bpos = bpos.below(), 17)) <= 4) continue;
            length = MHelper.randRange(3, length, random);
            for (int i = 0; i < length - 2; ++i) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos.below(i), vine);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos.below(length - 2), (BlockState)vine.setValue(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos.below(length - 1), (BlockState)vine.setValue(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
        }
        return true;
    }

    private boolean canReplace(BlockState state) {
        return state.canBeReplaced() || state.getBlock() == NetherBlocks.GIANT_LUCIS || state.getBlock() == NetherBlocks.LUCIS_MUSHROOM || state.getBlock() instanceof BlockPlantWall;
    }

    private void buildLine(List<BlockPos> blocks, double radius, StructureGeneratorThreadContext context) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            BlockPos a = blocks.get(i);
            BlockPos b = blocks.get(i + 1);
            if (b.getY() < a.getY()) {
                BlockPos c = b;
                b = a;
                a = c;
            }
            int count = (int)Math.ceil(Math.sqrt(b.distSqr((Vec3i)a)));
            for (int j = 0; j < count; ++j) {
                this.sphere(this.lerpCos(a, b, (double)j / (double)count), radius, context);
            }
        }
    }

    private BlockPos lerpCos(BlockPos start, BlockPos end, double mix) {
        double v = this.lcos(mix);
        double x = Mth.lerp((double)v, (double)start.getX(), (double)end.getX());
        double y = Mth.lerp((double)v, (double)start.getY(), (double)end.getY());
        double z = Mth.lerp((double)v, (double)start.getZ(), (double)end.getZ());
        return new BlockPos((int)x, (int)y, (int)z);
    }

    private double lcos(double mix) {
        return Mth.clamp((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<BlockPos> lineParable(BlockPos start, BlockPos end, int count, RandomSource random, double range) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(count);
        int max = count - 1;
        int middle = count / 2;
        result.add(start);
        double size = Math.sqrt(start.distSqr((Vec3i)end)) * 0.8;
        for (int i = 1; i < max; ++i) {
            double offset = (double)(i - middle) / (double)middle;
            offset = 1.0 - offset * offset;
            double delta = (double)i / (double)max;
            double x = Mth.lerp((double)delta, (double)start.getX(), (double)end.getX()) + random.nextGaussian() * range;
            double y = Mth.lerp((double)delta, (double)start.getY(), (double)end.getY()) - offset * size;
            double z = Mth.lerp((double)delta, (double)start.getZ(), (double)end.getZ()) + random.nextGaussian() * range;
            result.add(new BlockPos((int)x, (int)y, (int)z));
        }
        result.add(end);
        return result;
    }

    private void sphere(BlockPos pos, double radius, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.getX() - radius);
        int y1 = MHelper.floor((double)pos.getY() - radius);
        int z1 = MHelper.floor((double)pos.getZ() - radius);
        int x2 = MHelper.floor((double)pos.getX() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.getY() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.getZ() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.getX();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.getZ();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.getY();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    context.BLOCKS.add(new BlockPos(x, y, z));
                }
            }
        }
    }
}

