/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockBrownLargeMushroom;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class BigBrownMushroomFeature
extends ContextFeature<NoneFeatureConfiguration> {
    private static final Map<BNBlockProperties.BrownMushroomShape, BlockState> STATE_CACHE = new EnumMap<BNBlockProperties.BrownMushroomShape, BlockState>(BNBlockProperties.BrownMushroomShape.class);

    private static BlockState state(BNBlockProperties.BrownMushroomShape shape) {
        return STATE_CACHE.computeIfAbsent(shape, s -> (BlockState)NetherBlocks.BROWN_LARGE_MUSHROOM.defaultBlockState().setValue(BlockBrownLargeMushroom.SHAPE, (Comparable)((Object)s)));
    }

    public BigBrownMushroomFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int size = org.betterx.bclib.util.BlocksHelper.blockCount((LevelAccessor)level, (BlockPos)pos, (Direction)Direction.UP, (int)(2 + random.nextInt(3)), org.betterx.bclib.util.BlocksHelper::isFree);
        if (size < 3) {
            return false;
        }
        boolean hasAir = true;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                hasAir = hasAir && level.isEmptyBlock(pos.above(size).offset(x, 0, z));
            }
        }
        if (hasAir) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos, BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.BOTTOM));
            for (int y = 1; y < size; ++y) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.above(y), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.MIDDLE));
            }
            pos = pos.above(size);
            BlocksHelper.setWithUpdate((LevelAccessor)level, pos, BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.TOP));
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.north(), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.SIDE_N));
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.south(), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.SIDE_S));
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.east(), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.SIDE_E));
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.west(), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.SIDE_W));
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.north().east(), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.CORNER_N));
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.north().west(), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.CORNER_W));
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.south().east(), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.CORNER_E));
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos.south().west(), BigBrownMushroomFeature.state(BNBlockProperties.BrownMushroomShape.CORNER_S));
            return true;
        }
        return false;
    }
}

