/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockStalactite;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class BlockFixFeature
extends DefaultFeature {
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        BlockPos worldPos = featurePlaceContext.origin();
        WorldGenLevel level = featurePlaceContext.level();
        int sx = worldPos.getX() >> 4 << 4;
        int sz = worldPos.getZ() >> 4 << 4;
        BlockFixFeature.fixBlocks(level, sx, 30, sz, sx + 15, 110, sz + 15);
        return true;
    }

    private static void fixBlocks(WorldGenLevel world, int x1, int y1, int z1, int x2, int y2, int z2) {
        StructureGeneratorThreadContext ctx = NetherThreadDataStorage.generatorForThread().context;
        BlockPos.MutableBlockPos popPos = ctx.POS;
        BlockPos.MutableBlockPos abovePos = ctx.POS2;
        BlockPos.MutableBlockPos belowPos = ctx.POS3;
        for (int y = y1; y <= y2; ++y) {
            popPos.setY(y);
            abovePos.setY(y + 1);
            belowPos.setY(y - 1);
            for (int x = x1; x <= x2; ++x) {
                popPos.setX(x);
                abovePos.setX(x);
                belowPos.setX(x);
                for (int z = z1; z <= z2; ++z) {
                    popPos.setZ(z);
                    abovePos.setZ(z);
                    belowPos.setZ(z);
                    BlockState state = world.getBlockState((BlockPos)popPos);
                    if (!state.canSurvive((LevelReader)world, (BlockPos)popPos)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    BlockState aboveState = world.getBlockState((BlockPos)abovePos);
                    if (!state.canOcclude() && aboveState.is(Blocks.NETHER_BRICKS)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)popPos, Blocks.NETHER_BRICKS.defaultBlockState());
                        continue;
                    }
                    if (org.betterx.bclib.util.BlocksHelper.isLava((BlockState)state) && world.isEmptyBlock((BlockPos)abovePos) && world.isEmptyBlock((BlockPos)belowPos)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    if (state.getBlock() == Blocks.NETHER_WART_BLOCK || state.getBlock() == Blocks.WARPED_WART_BLOCK) {
                        if (!world.isEmptyBlock((BlockPos)belowPos) || !world.isEmptyBlock((BlockPos)abovePos) || !world.isEmptyBlock(popPos.north()) || !world.isEmptyBlock(popPos.south()) || !world.isEmptyBlock(popPos.east()) || !world.isEmptyBlock(popPos.west())) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    if (!(state.getBlock() instanceof BlockStalactite) || (state = world.getBlockState((BlockPos)belowPos)).isCollisionShapeFullBlock((BlockGetter)world, (BlockPos)belowPos) || state.getBlock() instanceof BlockStalactite) continue;
                    BlockPos.MutableBlockPos sp = new BlockPos.MutableBlockPos().set((Vec3i)popPos);
                    while (world.getBlockState((BlockPos)sp).getBlock() instanceof BlockStalactite) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)sp, AIR);
                        sp.relative(Direction.UP);
                    }
                }
            }
        }
    }
}

