/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockJellyfishMushroom;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class JellyfishMushroomFeature
extends ContextFeature<NoneFeatureConfiguration>
implements GrowableFeature<NoneFeatureConfiguration> {
    public JellyfishMushroomFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (world.isEmptyBlock(pos) && world.getBlockState(pos.below()).is(BlockTags.NYLIUM)) {
            this.grow(world, pos, random);
            return true;
        }
        return false;
    }

    public void grow(ServerLevelAccessor world, BlockPos pos, RandomSource random) {
        if (random.nextBoolean() && world.isEmptyBlock(pos.above())) {
            this.growMedium(world, pos);
        } else {
            this.growSmall(world, pos);
        }
    }

    public void growSmall(ServerLevelAccessor world, BlockPos pos) {
        Block down = world.getBlockState(pos.below()).getBlock();
        BNBlockProperties.JellyShape visual = down == NetherBlocks.MUSHROOM_GRASS ? BNBlockProperties.JellyShape.NORMAL : (down == NetherBlocks.SEPIA_MUSHROOM_GRASS ? BNBlockProperties.JellyShape.SEPIA : BNBlockProperties.JellyShape.POOR);
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)((BlockState)NetherBlocks.JELLYFISH_MUSHROOM.defaultBlockState().setValue(BlockJellyfishMushroom.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)).setValue(BlockJellyfishMushroom.VISUAL, (Comparable)((Object)visual)));
    }

    public void growMedium(ServerLevelAccessor world, BlockPos pos) {
        Block down = world.getBlockState(pos.below()).getBlock();
        BNBlockProperties.JellyShape visual = down == NetherBlocks.MUSHROOM_GRASS ? BNBlockProperties.JellyShape.NORMAL : (down == NetherBlocks.SEPIA_MUSHROOM_GRASS ? BNBlockProperties.JellyShape.SEPIA : BNBlockProperties.JellyShape.POOR);
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)((BlockState)NetherBlocks.JELLYFISH_MUSHROOM.defaultBlockState().setValue(BlockJellyfishMushroom.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE)).setValue(BlockJellyfishMushroom.VISUAL, (Comparable)((Object)visual)));
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos.above(), (BlockState)((BlockState)NetherBlocks.JELLYFISH_MUSHROOM.defaultBlockState().setValue(BlockJellyfishMushroom.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).setValue(BlockJellyfishMushroom.VISUAL, (Comparable)((Object)visual)));
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration configuration) {
        this.grow(level, pos, random);
        return true;
    }
}

