/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockLucisMushroom;
import org.betterx.betternether.blocks.BlockLucisSpore;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class LucisFeature
extends ContextFeature<NoneFeatureConfiguration>
implements GrowableFeature<NoneFeatureConfiguration> {
    private static final Supplier<BlockState> CENTER = () -> LucisFeature.baseState(BNBlockProperties.EnumLucisShape.CENTER);
    private static final Supplier<BlockState> SIDE = () -> LucisFeature.baseState(BNBlockProperties.EnumLucisShape.SIDE);
    private static final Supplier<BlockState> CORNER = () -> LucisFeature.baseState(BNBlockProperties.EnumLucisShape.CORNER);

    public LucisFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        return this.grow(world, pos, random, false);
    }

    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, boolean force) {
        if (force || this.canGenerate(world, pos)) {
            if (random.nextInt(3) == 0) {
                if (this.canReplace(world.getBlockState(pos))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos, CENTER.get());
                }
                if (this.canReplace(world.getBlockState(pos.north()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.north(), (BlockState)SIDE.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.NORTH));
                }
                if (this.canReplace(world.getBlockState(pos.south()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.south(), (BlockState)SIDE.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.SOUTH));
                }
                if (this.canReplace(world.getBlockState(pos.east()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.east(), (BlockState)SIDE.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.EAST));
                }
                if (this.canReplace(world.getBlockState(pos.west()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.west(), (BlockState)SIDE.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.WEST));
                }
                if (this.canReplace(world.getBlockState(pos.north().east()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.north().east(), (BlockState)CORNER.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.SOUTH));
                }
                if (this.canReplace(world.getBlockState(pos.north().west()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.north().west(), (BlockState)CORNER.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.EAST));
                }
                if (this.canReplace(world.getBlockState(pos.south().east()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.south().east(), (BlockState)CORNER.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.WEST));
                }
                if (this.canReplace(world.getBlockState(pos.south().west()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.south().west(), (BlockState)CORNER.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.NORTH));
                }
            } else {
                BlockState state = world.getBlockState(pos);
                if (state.getBlock() == NetherBlocks.LUCIS_SPORE) {
                    if (state.getValue((Property)BlockLucisSpore.FACING) == Direction.SOUTH) {
                        pos = pos.north();
                    } else if (state.getValue((Property)BlockLucisSpore.FACING) == Direction.WEST) {
                        pos = pos.east();
                    }
                } else if (!world.getBlockState(pos.north()).isAir()) {
                    pos = pos.north();
                } else if (!world.getBlockState(pos.east()).isAir()) {
                    pos = pos.east();
                }
                if (this.canReplace(world.getBlockState(pos))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)CORNER.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.SOUTH));
                }
                if (this.canReplace(world.getBlockState(pos.west()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.west(), (BlockState)CORNER.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.EAST));
                }
                if (this.canReplace(world.getBlockState(pos.south()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.south(), (BlockState)CORNER.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.WEST));
                }
                if (this.canReplace(world.getBlockState(pos.south().west()))) {
                    BlocksHelper.setWithUpdate((LevelAccessor)world, pos.south().west(), (BlockState)CORNER.get().setValue((Property)BlockLucisMushroom.FACING, (Comparable)Direction.NORTH));
                }
            }
            return true;
        }
        return false;
    }

    private boolean canReplace(BlockState state) {
        return state.getBlock() == NetherBlocks.LUCIS_SPORE || state.canBeReplaced();
    }

    private boolean canGenerate(ServerLevelAccessor world, BlockPos pos) {
        for (Direction dir : HorizontalDirectionalBlock.FACING.getPossibleValues()) {
            BlockState state = world.getBlockState(pos.relative(dir));
            if (!BlocksHelper.isNetherrack(state) && !NetherBlocks.MAT_ANCHOR_TREE.isTreeLog(state.getBlock())) continue;
            return true;
        }
        return false;
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration configuration) {
        return this.grow(level, pos, random, true);
    }

    private static BlockState baseState(BNBlockProperties.EnumLucisShape shape) {
        return (BlockState)NetherBlocks.LUCIS_MUSHROOM.defaultBlockState().setValue(BlockLucisMushroom.SHAPE, (Comparable)((Object)shape));
    }
}

