/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class NetherSakuraFeature
extends ContextFeature<NoneFeatureConfiguration>
implements GrowableFeature<NoneFeatureConfiguration> {
    public NetherSakuraFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if ((double)pos.getY() < (double)MAX_HEIGHT * 0.75) {
            return false;
        }
        return this.grow(world, pos, random, MAX_HEIGHT, context);
    }

    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        context.LOGS_DIST.clear();
        int l = MHelper.randRange((int)(15.0f * scale_factor), (int)(24.0f * scale_factor), random);
        double height = MHelper.randRange((int)(10.0f * scale_factor), (int)(15.0f * scale_factor), random);
        double radius = height * (0.2 + random.nextDouble() * 0.1);
        if ((double)l + height - (double)BlocksHelper.downRay((LevelAccessor)world, pos, (int)((double)l + height)) > 10.0) {
            return false;
        }
        l = BlocksHelper.downRay((LevelAccessor)world, pos, l + 1);
        int l2 = l * 2 / 3;
        for (int x = -3; x <= 3; ++x) {
            int x2 = x * x;
            context.POS.setX(pos.getX() + x);
            for (int z = -3; z <= 3; ++z) {
                int z2 = z * z;
                double d = (double)(x2 + z2) + 1.4;
                if (!(d < 10.0)) continue;
                if (d < 2.8 || random.nextBoolean()) {
                    int start;
                    context.POS.setZ(pos.getZ() + z);
                    double length = (double)MHelper.randRange(l2, l, random) / (d > 2.0 ? d : 1.0);
                    if (length < 1.0) {
                        length = 1.0;
                    }
                    int y = start = MHelper.randRange(-2, 0, random);
                    while ((double)y < length) {
                        context.POS.setY(pos.getY() - y);
                        if (this.canReplace(world.getBlockState((BlockPos)context.POS))) {
                            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_NETHER_SAKURA.getLog().defaultBlockState());
                            this.updateSDFFrom((BlockPos)context.POS, context);
                        }
                        ++y;
                    }
                    if (NetherBlocks.MAT_NETHER_SAKURA.isTreeLog(world.getBlockState((BlockPos)context.POS).getBlock())) {
                        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_NETHER_SAKURA.getBark().defaultBlockState());
                        this.updateSDFFrom((BlockPos)context.POS, context);
                    }
                }
                if (!(d < 2.0)) continue;
                this.crown((LevelAccessor)world, (BlockPos)context.POS, radius, height, context);
            }
        }
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        return true;
    }

    private void updateSDFFrom(BlockPos bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    int dist = Math.abs(x) + Math.abs(y) + Math.abs(z);
                    BlockPos blPos = bpos.offset(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void updateDistances(ServerLevelAccessor world, StructureGeneratorThreadContext context) {
        for (Map.Entry<BlockPos, Byte> entry : context.LOGS_DIST.entrySet()) {
            int dist = entry.getValue().byteValue();
            BlockPos logPos = entry.getKey();
            BlockState currentState = world.getBlockState(logPos);
            if (!currentState.hasProperty((Property)BlockStateProperties.DISTANCE)) continue;
            int cDist = (Integer)currentState.getValue((Property)BlockStateProperties.DISTANCE);
            if (dist < cDist && dist <= 7) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, logPos, (BlockState)currentState.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(dist)));
            } else {
                dist = cDist;
            }
            if (dist <= 7) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, logPos, Blocks.AIR.defaultBlockState());
        }
    }

    private void crown(LevelAccessor world, BlockPos pos, double radius, double height, StructureGeneratorThreadContext context) {
        int cz2;
        int cz;
        int cx2;
        int cx;
        BlockState leaves = (BlockState)NetherBlocks.NETHER_SAKURA_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
        double r2 = radius * radius;
        int start = (int)Math.floor(-radius);
        int cy = 0;
        while ((double)cy <= radius) {
            int cy2 = cy * cy;
            context.POS2.setY(pos.getY() + cy);
            cx = start;
            while ((double)cx <= radius) {
                cx2 = cx * cx;
                context.POS2.setX(pos.getX() + cx);
                cz = start;
                while ((double)cz <= radius) {
                    cz2 = cz * cz;
                    if ((double)(cx2 + cy2 + cz2) < r2) {
                        context.POS2.setZ(pos.getZ() + cz);
                        if (world.getBlockState((BlockPos)context.POS2).canBeReplaced()) {
                            BlocksHelper.setWithUpdate(world, (BlockPos)context.POS2, leaves);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
        int cy2 = 0;
        while ((double)cy2 <= height) {
            r2 = radius * (1.0 - (double)cy2 / height);
            r2 *= r2;
            context.POS2.setX(pos.getX());
            context.POS2.setZ(pos.getZ());
            context.POS2.setY(pos.getY() - cy2);
            BlockState state = world.getBlockState((BlockPos)context.POS2);
            if (!state.canBeReplaced() && !NetherBlocks.MAT_NETHER_SAKURA.isTreeLog(state.getBlock())) {
                return;
            }
            cx = start;
            while ((double)cx <= radius) {
                cx2 = cx * cx;
                context.POS2.setX(pos.getX() + cx);
                cz = start;
                while ((double)cz <= radius) {
                    cz2 = cz * cz;
                    if ((double)(cx2 + cz2) < r2) {
                        context.POS2.setZ(pos.getZ() + cz);
                        if (world.getBlockState((BlockPos)context.POS2).canBeReplaced()) {
                            BlocksHelper.setWithUpdate(world, (BlockPos)context.POS2, leaves);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy2;
        }
    }

    private boolean canReplace(BlockState state) {
        return BlocksHelper.isNetherGround(state) || state.canBeReplaced();
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration configuration) {
        return this.grow(level, pos, random, 128, NetherThreadDataStorage.generatorForThread().context);
    }
}

