/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.blocks.RubeusLog;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.features.NonOverlappingFeature;
import org.betterx.betternether.world.features.configs.NaturalTreeConfiguration;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class RubeusTreeFeature
extends NonOverlappingFeature<NaturalTreeConfiguration>
implements GrowableFeature<NaturalTreeConfiguration> {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final int MIDDLE_Y = 10;

    public RubeusTreeFeature() {
        super(NaturalTreeConfiguration.CODEC);
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return state.getBlock() == NetherBlocks.MAT_RUBEUS.getLog();
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isNetherGround(state);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int length = BlocksHelper.upRay((LevelAccessor)world, pos, 27);
        if (length >= 25) {
            return super.place(world, pos, random, config, MAX_HEIGHT, context);
        }
        return false;
    }

    private void updateSDFFrom(BlockPos bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    int dist;
                    if (x == 0 && y == 0 && z == 0 || (dist = Math.abs(x) + Math.abs(y) + Math.abs(z)) > 7) continue;
                    BlockPos blPos = bpos.offset(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void updateDistances(ServerLevelAccessor world, StructureGeneratorThreadContext context) {
        for (Map.Entry<BlockPos, Byte> entry : context.LOGS_DIST.entrySet()) {
            byte dist = entry.getValue();
            BlockPos logPos = entry.getKey();
            BlockState currentState = world.getBlockState(logPos);
            if (!currentState.hasProperty((Property)BlockStateProperties.DISTANCE)) continue;
            int cDist = (Integer)currentState.getValue((Property)BlockStateProperties.DISTANCE);
            if (dist < cDist) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, logPos, (BlockState)currentState.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(dist)));
                cDist = dist;
            }
            if (cDist < 7) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, logPos, Blocks.AIR.defaultBlockState());
        }
    }

    @Override
    public boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, StructureGeneratorThreadContext context) {
        boolean natural = config.natural;
        context.clear();
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 0);
        float scale = MHelper.randRange(0.5f, 1.0f, random);
        int minCount = (double)scale < 0.75 ? 3 : 4;
        int maxCount = (double)scale < 0.75 ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 0.8f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.getX() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.getY() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.getZ() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 5.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((LevelAccessor)world, x1, y1 + 1, z1, crownR, random);
            int middle = Math.round((float)pos.getY() + (float)(10 + MHelper.randRange(-2, 2, random)) * branchSize);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.getX() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.getY() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.getZ() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.getBlockState((BlockPos)context.POS.set(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.getBlockState((BlockPos)context.POS.set(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.getX();
                        y2 = pos.getY();
                        generate = false;
                    }
                }
                this.line((LevelAccessor)world, x1, y1, z1, x2, y2, z2, middle, context);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        Iterator<BlockPos> iterator = context.TOP.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos == null || !context.POINTS.contains(bpos.above()) || context.TOP.contains(bpos.above())) continue;
            iterator.remove();
        }
        iterator = context.MIDDLE.iterator();
        while (iterator.hasNext()) {
            BlockPos bpos = iterator.next();
            if (bpos != null) {
                BlockPos up = bpos.above();
                if (!context.MIDDLE.contains(up) && (context.TOP.contains(up) || !context.POINTS.contains(up))) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        for (BlockPos bpos : context.POINTS) {
            if (context.POINTS.contains(bpos.above()) && context.POINTS.contains(bpos.below())) {
                state = NetherBlocks.MAT_RUBEUS.getLog().defaultBlockState();
                if (context.MIDDLE.contains(bpos)) {
                    this.setCondition((LevelAccessor)world, bpos, pos.getY(), (BlockState)state.setValue(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE), false, random);
                } else if (context.TOP.contains(bpos)) {
                    this.setCondition((LevelAccessor)world, bpos, pos.getY(), (BlockState)state.setValue(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.TOP), false, random);
                } else {
                    this.setCondition((LevelAccessor)world, bpos, pos.getY(), (BlockState)state.setValue(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM), natural, random);
                }
            } else {
                state = NetherBlocks.MAT_RUBEUS.getBark().defaultBlockState();
                if (context.MIDDLE.contains(bpos)) {
                    this.setCondition((LevelAccessor)world, bpos, pos.getY(), (BlockState)state.setValue(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE), false, random);
                } else if (context.TOP.contains(bpos)) {
                    this.setCondition((LevelAccessor)world, bpos, pos.getY(), (BlockState)state.setValue(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.TOP), false, random);
                } else {
                    this.setCondition((LevelAccessor)world, bpos, pos.getY(), (BlockState)state.setValue(RubeusLog.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM), natural, random);
                }
            }
            this.updateSDFFrom(bpos, context);
        }
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        context.POINTS.clear();
        context.MIDDLE.clear();
        context.TOP.clear();
        return true;
    }

    private void line(LevelAccessor level, int x1, int y1, int z1, int x2, int y2, int z2, int middleY, StructureGeneratorThreadContext context) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = context.POS.set(x1, y1, z1).immutable();
        context.POINTS.add(pos);
        if (pos.getY() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.getY() > middleY) {
            context.TOP.add(pos);
        }
        pos = context.POS.set(x2, y2, z2).immutable();
        context.POINTS.add(pos);
        if (pos.getY() == middleY) {
            context.MIDDLE.add(pos);
        } else if (pos.getY() > middleY) {
            context.TOP.add(pos);
        }
        for (int i = 0; i < mx; ++i) {
            context.POS.set(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            pos = context.POS.immutable();
            context.POINTS.add(pos);
            if (context.POS.getY() == middleY) {
                context.MIDDLE.add(pos);
                continue;
            }
            if (context.POS.getY() <= middleY) continue;
            context.TOP.add(pos);
        }
    }

    private void crown(LevelAccessor world, int x, int y, int z, float radius, RandomSource random) {
        int start;
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        BlockState leaves = (BlockState)NetherBlocks.RUBEUS_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true));
        BlockState cone = NetherBlocks.MAT_RUBEUS.getCone().defaultBlockState();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.setY((int)((float)(y + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx;
                POS.setX(x + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    int cz2 = cz * cz;
                    if ((float)(cx2 + cy2_out + cz2) < r2 && (float)cx2 + cy2_in + (float)cz2 > r2) {
                        POS.setZ(z + cz);
                        this.setIfAirLeaves(world, (BlockPos)POS, leaves);
                        if ((POS.getX() + POS.getZ() & 1) == 0 && random.nextInt(6) == 0) {
                            this.setIfAir(world, POS.below(), cone);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    private void setCondition(LevelAccessor world, BlockPos pos, int y, BlockState state, boolean moss, RandomSource random) {
        if (pos.getY() > y) {
            this.setIfAir(world, pos, state);
        } else {
            this.setIfGroundOrAir(world, pos, state);
        }
        if (moss && Math.abs(pos.getY() - y) < 4) {
            for (Direction dir : BlocksHelper.HORIZONTAL) {
                if (random.nextInt(3) <= 0) continue;
                this.setIfAir(world, pos.relative(dir), (BlockState)NetherBlocks.JUNGLE_MOSS.defaultBlockState().setValue((Property)BlockPlantWall.FACING, (Comparable)dir));
            }
        }
    }

    private void setIfAir(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState bState = world.getBlockState(pos);
        if ((world.isEmptyBlock(pos) || bState.canBeReplaced() || bState.getBlock() == NetherBlocks.RUBEUS_LEAVES) && state.canSurvive((LevelReader)world, pos)) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfGroundOrAir(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState bState = world.getBlockState(pos);
        if ((bState.isAir() || bState.getBlock() == NetherBlocks.RUBEUS_LEAVES || bState.canBeReplaced() || BlocksHelper.isNetherGround(bState)) && state.canSurvive((LevelReader)world, pos)) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    private void setIfAirLeaves(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockState bState = world.getBlockState(pos);
        if (world.isEmptyBlock(pos) || bState.canBeReplaced()) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NaturalTreeConfiguration configuration) {
        return this.grow(level, pos, random, new NaturalTreeConfiguration(false, configuration.distance), NetherThreadDataStorage.generatorForThread().context);
    }
}

