/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class WartCapFeature
extends ContextFeature<NoneFeatureConfiguration> {
    private static final BlockState INSIDE = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.RED_MUSHROOM_BLOCK.defaultBlockState().setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)HugeMushroomBlock.DOWN, (Comparable)Boolean.valueOf(false));
    private static final BlockState SKIN = Blocks.NETHER_WART_BLOCK.defaultBlockState();

    public WartCapFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int z;
        int x;
        int y;
        if (!this.isWall(world, pos) || (double)pos.getY() > (double)MAX_HEIGHT * 0.45 || (double)pos.getY() < (double)MAX_HEIGHT * 0.25 || world.isEmptyBlock(pos.below(3))) {
            return false;
        }
        int radius = 3 + random.nextInt(3);
        int r2 = radius * radius;
        int side = radius * 2 + 1;
        int y1 = radius >> 1;
        BlockState[][][] shape = new BlockState[side][y1 + 1][side];
        for (y = 0; y <= y1; ++y) {
            context.POS.setY(pos.getY() + y);
            for (x = -radius; x <= radius; ++x) {
                context.POS.setX(pos.getX() + x);
                int sx = x + radius;
                for (int z2 = -radius; z2 <= radius; ++z2) {
                    context.POS.setZ(pos.getZ() + z2);
                    int sz = z2 + radius;
                    int d = x * x + y * y * 6 + z2 * z2;
                    if (d > r2) continue;
                    shape[sx][y][sz] = y == y1 || x == -radius || x == radius || z2 == -radius || z2 == radius ? SKIN : INSIDE;
                }
            }
        }
        for (y = 0; y < y1; ++y) {
            for (x = 1; x < side - 1; ++x) {
                for (z = 1; z < side - 1; ++z) {
                    if (shape[x][y][z] == null || shape[x - 1][y][z] != null && shape[x + 1][y][z] != null && shape[x][y][z - 1] != null && shape[x][y][z + 1] != null && shape[x][y + 1][z] != null) continue;
                    shape[x][y][z] = SKIN;
                }
            }
        }
        for (y = 0; y <= y1; ++y) {
            context.POS.setY(pos.getY() + y);
            for (x = 0; x < side; ++x) {
                context.POS.setX(pos.getX() + x - radius);
                for (z = 0; z < side; ++z) {
                    context.POS.setZ(pos.getZ() + z - radius);
                    if (shape[x][y][z] == null || !world.isEmptyBlock((BlockPos)context.POS)) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)context.POS, shape[x][y][z]);
                }
            }
        }
        return true;
    }

    private boolean isWall(ServerLevelAccessor world, BlockPos pos) {
        for (Direction dir : HorizontalDirectionalBlock.FACING.getPossibleValues()) {
            if (world.getBlockState(pos.relative(dir)).getBlock() != Blocks.NETHER_BRICKS) continue;
            return true;
        }
        return false;
    }
}

