/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockWartSeed;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.features.NonOverlappingFeature;
import org.betterx.betternether.world.features.configs.NaturalTreeConfiguration;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.wover.feature.api.features.GrowableFeature;

public class WartTreeFeature
extends NonOverlappingFeature<NaturalTreeConfiguration>
implements GrowableFeature<NaturalTreeConfiguration> {
    private static final BlockState WART_BLOCK = Blocks.NETHER_WART_BLOCK.defaultBlockState();
    private static final Direction[] HORIZONTAL = HorizontalDirectionalBlock.FACING.getPossibleValues().toArray(new Direction[0]);

    public WartTreeFeature() {
        super(NaturalTreeConfiguration.CODEC);
    }

    @Override
    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, StructureGeneratorThreadContext context) {
        if (world.isEmptyBlock(pos.above(1)) && world.isEmptyBlock(pos.above(2))) {
            if (world.isEmptyBlock(pos.above(2).north()) && world.isEmptyBlock(pos.above(2).south()) && world.isEmptyBlock(pos.above(2).east()) && world.isEmptyBlock(pos.above(2).west()) && world.isEmptyBlock(pos.above(3).north(2)) && world.isEmptyBlock(pos.above(3).south(2)) && world.isEmptyBlock(pos.above(3).east(2)) && world.isEmptyBlock(pos.above(3).west(2))) {
                int py;
                int y;
                int pz;
                int z;
                int px;
                int x;
                int height = 5 + random.nextInt(5);
                int h2 = height - 1;
                int width = (height >>> 2) + 1;
                int offset = width >>> 1;
                ArrayList<BlockPos> seedBlocks = new ArrayList<BlockPos>();
                for (x = 0; x < width; ++x) {
                    px = x + pos.getX() - offset;
                    for (z = 0; z < width; ++z) {
                        pz = z + pos.getZ() - offset;
                        for (y = 0; y < height; ++y) {
                            py = y + pos.getY();
                            context.POS.set(px, py, pz);
                            if (!this.isReplaceable(world.getBlockState((BlockPos)context.POS))) continue;
                            if (y == 0 && !this.isReplaceable(world.getBlockState(context.POS.below()))) {
                                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_WART.getRoot().defaultBlockState());
                            } else if (y < h2) {
                                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_WART.getLog().defaultBlockState());
                            } else {
                                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, WART_BLOCK);
                            }
                            if (random.nextInt(8) != 0) continue;
                            Direction dir = HORIZONTAL[random.nextInt(HORIZONTAL.length)];
                            seedBlocks.add(new BlockPos((Vec3i)context.POS).relative(dir));
                        }
                    }
                }
                for (x = 0; x < width; ++x) {
                    px = x + pos.getX() - offset;
                    block4: for (z = 0; z < width; ++z) {
                        pz = z + pos.getZ() - offset;
                        for (y = 1; y < height >> 1; ++y) {
                            py = pos.getY() - y;
                            context.POS.set(px, py, pz);
                            if (!this.isReplaceable(world.getBlockState((BlockPos)context.POS))) continue;
                            if (this.isReplaceable(world.getBlockState(context.POS.below()))) {
                                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_WART.getLog().defaultBlockState());
                                continue;
                            }
                            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, NetherBlocks.MAT_WART.getRoot().defaultBlockState());
                            continue block4;
                        }
                    }
                }
                int headWidth = width + 2;
                ++offset;
                height = height - width - 1 + pos.getY();
                for (int x2 = 0; x2 < headWidth; ++x2) {
                    int px2 = x2 + pos.getX() - offset;
                    for (int z2 = 0; z2 < headWidth; ++z2) {
                        if (x2 == z2 || x2 == headWidth - z2 - 1) continue;
                        int pz2 = z2 + pos.getZ() - offset;
                        for (int y2 = 0; y2 < width; ++y2) {
                            int py2 = y2 + height;
                            context.POS.set(px2, py2, pz2);
                            if (!world.isEmptyBlock((BlockPos)context.POS)) continue;
                            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)context.POS, WART_BLOCK);
                            for (int i = 0; i < 4; ++i) {
                                seedBlocks.add(new BlockPos((Vec3i)context.POS).relative(Direction.values()[random.nextInt(6)]));
                            }
                        }
                    }
                }
                for (BlockPos pos2 : seedBlocks) {
                    this.PlaceRandomSeed((LevelAccessor)world, pos2);
                }
            }
            return true;
        }
        return false;
    }

    private void PlaceRandomSeed(LevelAccessor world, BlockPos pos) {
        BlockState seed = NetherBlocks.MAT_WART.getSeed().defaultBlockState();
        if (this.isReplaceable(world.getBlockState(pos))) {
            if (this.isWart(world.getBlockState(pos.above()))) {
                seed = (BlockState)seed.setValue((Property)BlockWartSeed.FACING, (Comparable)Direction.DOWN);
            } else if (this.isWart(world.getBlockState(pos.below()))) {
                seed = (BlockState)seed.setValue((Property)BlockWartSeed.FACING, (Comparable)Direction.UP);
            } else if (this.isWart(world.getBlockState(pos.north()))) {
                seed = (BlockState)seed.setValue((Property)BlockWartSeed.FACING, (Comparable)Direction.SOUTH);
            } else if (this.isWart(world.getBlockState(pos.south()))) {
                seed = (BlockState)seed.setValue((Property)BlockWartSeed.FACING, (Comparable)Direction.NORTH);
            } else if (this.isWart(world.getBlockState(pos.east()))) {
                seed = (BlockState)seed.setValue((Property)BlockWartSeed.FACING, (Comparable)Direction.WEST);
            } else if (this.isWart(world.getBlockState(pos.west()))) {
                seed = (BlockState)seed.setValue((Property)BlockWartSeed.FACING, (Comparable)Direction.EAST);
            }
            BlocksHelper.setWithUpdate(world, pos, seed);
        }
    }

    private boolean isReplaceable(BlockState state) {
        Block block = state.getBlock();
        return state.canBeReplaced() || block == Blocks.AIR || block == NetherBlocks.MAT_WART.getSeed() || block == NetherBlocks.BLACK_BUSH || block == NetherBlocks.SOUL_VEIN || block == NetherBlocks.SOUL_LILY || block == NetherBlocks.SOUL_LILY_SAPLING || block == Blocks.NETHER_WART;
    }

    private boolean isWart(BlockState state) {
        return state == WART_BLOCK || state.getBlock() == NetherBlocks.MAT_WART.getLog();
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return this.isWart(state);
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isSoulSand(state);
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NaturalTreeConfiguration configuration) {
        return this.grow(level, pos, random, new NaturalTreeConfiguration(false, configuration.distance), NetherThreadDataStorage.generatorForThread().context);
    }
}

