/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockNetherGrass;
import org.betterx.betternether.blocks.BlockWillowLeaves;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class WillowBushFeature
extends ContextFeature<NoneFeatureConfiguration> {
    public WillowBushFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (!(world.isEmptyBlock(pos) && world.isEmptyBlock(pos.above()) && world.isEmptyBlock(pos.above(15)))) {
            return false;
        }
        float r = random.nextFloat() * 2.0f + 0.5f;
        int count = (int)r;
        for (int i = 0; i < count; ++i) {
            float fr = r - (float)i;
            int ir = (int)Math.ceil(fr);
            float r2 = fr * fr;
            int x1 = pos.getX() - ir;
            int x2 = pos.getX() + ir;
            int z1 = pos.getZ() - ir;
            int z2 = pos.getZ() + ir;
            context.POS.setY(pos.getY() + i);
            for (int x = x1; x < x2; ++x) {
                context.POS.setX(x);
                int sqx = x - pos.getX();
                sqx *= sqx;
                for (int z = z1; z < z2; ++z) {
                    int az;
                    int ay;
                    int sqz = z - pos.getZ();
                    sqz *= sqz;
                    context.POS.setZ(z);
                    if (!((float)(sqx + sqz) < r2 + random.nextFloat() * r)) continue;
                    int dx = context.POS.getX() - pos.getX();
                    int dy = context.POS.getY() - pos.getY();
                    int dz = context.POS.getZ() - pos.getZ();
                    int ax = Math.abs(dx);
                    int max = Math.max(ax, Math.max(ay = Math.abs(dy), az = Math.abs(dz)));
                    Direction dir = max == ax ? Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(dx > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)) : (max == ay ? Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)(dy > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)) : Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(dz > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)));
                    this.setIfAir((LevelAccessor)world, (BlockPos)context.POS, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)dir)).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, pos, NetherBlocks.MAT_WILLOW.getBlock(WoodSlots.BARK).defaultBlockState());
        this.setIfAir((LevelAccessor)world, pos.above(), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)Direction.UP)).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)));
        this.setIfAir((LevelAccessor)world, pos.north(), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)Direction.NORTH)).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)));
        this.setIfAir((LevelAccessor)world, pos.south(), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)Direction.SOUTH)).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)));
        this.setIfAir((LevelAccessor)world, pos.east(), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)Direction.EAST)).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)));
        this.setIfAir((LevelAccessor)world, pos.west(), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.defaultBlockState().setValue((Property)BlockWillowLeaves.FACING, (Comparable)Direction.WEST)).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)));
        return true;
    }

    private void setIfAir(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isEmptyBlock(pos) || world.getBlockState(pos).getBlock() instanceof BlockNetherGrass) {
            BlocksHelper.setWithoutUpdate(world, pos, state);
        }
    }
}

