/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.world.structures.city.CityGenerator;
import org.betterx.betternether.world.structures.city.palette.Palettes;
import org.betterx.betternether.world.structures.piece.CavePiece;
import org.betterx.betternether.world.structures.piece.CityPiece;
import org.betterx.wover.structure.api.StructureUtils;
import org.jetbrains.annotations.NotNull;

public class CityStructure
extends Structure {
    private static CityGenerator generator;
    public static final int RADIUS = 64;
    private static final int DEFAULT_HEIGHT = 40;

    public CityStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    public static void initGenerator() {
        generator = new CityGenerator();
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (StructureUtils.isValidBiome((Structure.GenerationContext)context, (int)40)) {
            ChunkPos cPos = context.chunkPos();
            ChunkGenerator chunkGenerator = context.chunkGenerator();
            LevelHeightAccessor heightAccessor = context.heightAccessor();
            BlockPos center = CityStructure.getCenter(context, cPos, chunkGenerator, heightAccessor);
            return Optional.of(new Structure.GenerationStub(center, structurePiecesBuilder -> CityStructure.generatePieces(structurePiecesBuilder, context)));
        }
        return Optional.empty();
    }

    private static void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        int d2;
        ChunkPos cPos = context.chunkPos();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor heightAccessor = context.heightAccessor();
        WorldgenRandom random = context.random();
        BlockPos center = CityStructure.getCenter(context, cPos, chunkGenerator, heightAccessor);
        ArrayList<CityPiece> buildings = generator.generate(center, (RandomSource)random, Palettes.EMPTY);
        BoundingBox cityBox = new BoundingBox(center);
        for (CityPiece p : buildings) {
            cityBox = cityBox.encapsulate(p.getBoundingBox());
        }
        int d1 = Math.max(center.getX() - cityBox.minX(), cityBox.maxX() - center.getX());
        int radius = Math.max(d1, d2 = Math.max(center.getZ() - cityBox.minZ(), cityBox.maxZ() - center.getZ()));
        if (radius / 2 + center.getY() < cityBox.maxY()) {
            radius = (cityBox.maxY() - center.getY()) / 2;
        }
        if (!(chunkGenerator instanceof FlatLevelSource)) {
            CavePiece cave = new CavePiece(center, radius + 8, (RandomSource)random, cityBox);
            structurePiecesBuilder.addPiece((StructurePiece)cave);
        }
        buildings.forEach(b -> structurePiecesBuilder.addPiece((StructurePiece)b));
        BetterNether.C.log.info("BBox:" + structurePiecesBuilder.getBoundingBox().toString());
    }

    @NotNull
    private static BlockPos getCenter(Structure.GenerationContext context, ChunkPos cPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor) {
        int px = cPos.getBlockX(8);
        int pz = cPos.getBlockZ(8);
        int y = chunkGenerator instanceof FlatLevelSource ? chunkGenerator.getBaseHeight(px, pz, Heightmap.Types.WORLD_SURFACE, heightAccessor, context.randomState()) : 40;
        BlockPos center = new BlockPos(px, y, pz);
        return center;
    }

    public StructureType<?> type() {
        return NetherStructures.CITY_STRUCTURE.type();
    }
}

