/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.world.structures.NetherStructureNBT;
import org.betterx.betternether.world.structures.city.BoundingBox2D;

public class StructureCityBuilding
extends NetherStructureNBT {
    protected static final BlockState AIR = Blocks.AIR.defaultBlockState();
    private BoundingBox2D bb;
    public BlockPos[] ends;
    private Direction[] dirs;
    private BlockPos rotationOffset;
    private int offsetY;

    public StructureCityBuilding(String structure) {
        super(BetterNether.C.id(structure));
        this.init();
    }

    public StructureCityBuilding(String structure, int offsetY) {
        super(BetterNether.C.id(structure));
        this.offsetY = offsetY;
        this.init();
    }

    protected StructureCityBuilding(ResourceLocation location, StructureTemplate structure) {
        super(location);
        this.structure = structure;
        this.init();
    }

    private void init() {
        Vec3i size = this.structure.getSize();
        this.bb = new BoundingBox2D(0, 0, size.getX(), size.getZ());
        ObjectArrayList map = this.structure.filterBlocks(BlockPos.ZERO, new StructurePlaceSettings(), Blocks.STRUCTURE_BLOCK, false);
        this.ends = new BlockPos[map.size()];
        this.dirs = new Direction[map.size()];
        int i = 0;
        BlockPos center = new BlockPos(size.getX() >> 1, size.getY(), size.getZ() >> 1);
        for (StructureTemplate.StructureBlockInfo info : map) {
            this.ends[i] = info.pos();
            this.dirs[i++] = this.getDir(info.pos().offset(-center.getX(), 0, -center.getZ()));
        }
        this.rotationOffset = new BlockPos(0, 0, 0);
        this.rotation = Rotation.NONE;
    }

    private Direction getDir(BlockPos pos) {
        int az;
        int ax = Math.abs(pos.getX());
        int mx = Math.max(ax, az = Math.abs(pos.getZ()));
        if (mx == ax) {
            if (pos.getX() > 0) {
                return Direction.EAST;
            }
            return Direction.WEST;
        }
        if (pos.getZ() > 0) {
            return Direction.SOUTH;
        }
        return Direction.NORTH;
    }

    public BoundingBox2D getBoungingBox() {
        return this.bb;
    }

    protected Rotation mirrorRotation(Rotation r) {
        switch (r) {
            case CLOCKWISE_90: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return r;
    }

    public void placeInChunk(ServerLevelAccessor world, BlockPos pos, BoundingBox boundingBox, StructureProcessor paletteProcessor) {
        BlockPos p = pos.offset((Vec3i)this.rotationOffset);
        this.structure.placeInWorld(world, p, p, new StructurePlaceSettings().setRotation(this.rotation).setMirror(this.mirror).setBoundingBox(boundingBox).addProcessor(paletteProcessor), world.getRandom(), 2);
    }

    public BlockPos[] getEnds() {
        return this.ends;
    }

    public int getEndsCount() {
        return this.ends.length;
    }

    public BlockPos getOffsettedPos(int index) {
        return this.ends[index].relative(this.dirs[index]);
    }

    public BlockPos getPos(int index) {
        return this.ends[index];
    }

    public StructureCityBuilding getRotated(Rotation rotation) {
        StructureCityBuilding building = this.clone();
        building.rotation = rotation;
        building.rotationOffset = new BlockPos(building.structure.getSize()).rotate(rotation);
        int x = building.rotationOffset.getX();
        int z = building.rotationOffset.getZ();
        x = x < 0 ? -x - 1 : 0;
        z = z < 0 ? -z - 1 : 0;
        building.rotationOffset = new BlockPos(x, 0, z);
        for (int i = 0; i < building.dirs.length; ++i) {
            building.dirs[i] = this.rotated(building.dirs[i], rotation);
            building.ends[i] = building.ends[i].rotate(rotation).offset((Vec3i)building.rotationOffset);
        }
        building.bb.rotate(rotation);
        building.offsetY = this.offsetY;
        return building;
    }

    public StructureCityBuilding getRandomRotated(RandomSource random) {
        return this.getRotated(Rotation.values()[random.nextInt(4)]);
    }

    public StructureCityBuilding clone() {
        return new StructureCityBuilding(this.location, this.structure);
    }

    private Direction rotated(Direction dir, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> dir.getClockWise();
            case Rotation.CLOCKWISE_180 -> dir.getOpposite();
            case Rotation.COUNTERCLOCKWISE_90 -> dir.getCounterClockWise();
            default -> dir;
        };
    }

    public int getYOffset() {
        return this.offsetY;
    }

    @Override
    public Rotation getRotation() {
        return this.rotation;
    }

    public BoundingBox getBoundingBox(BlockPos pos) {
        return this.structure.getBoundingBox(new StructurePlaceSettings().setRotation(this.rotation).setMirror(this.mirror), pos.offset((Vec3i)this.rotationOffset));
    }

    @Override
    public StructureCityBuilding setRotation(Rotation rotation) {
        this.rotation = rotation;
        this.rotationOffset = new BlockPos(this.structure.getSize()).rotate(rotation);
        return this;
    }
}

