/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city.palette;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockPottedPlant;
import org.betterx.betternether.blocks.BlockSmallLantern;
import org.betterx.betternether.registry.NetherBlocks;

public class CityPalette {
    private static final RandomSource RANDOM = new LegacyRandomSource(130520220057L);
    private final String name;
    private final List<Block> foundationBlocks = new ArrayList<Block>();
    private final List<Block> foundationSlabs = new ArrayList<Block>();
    private final List<Block> foundationStairs = new ArrayList<Block>();
    private final List<Block> foundationWalls = new ArrayList<Block>();
    private final List<Block> roofBlocks = new ArrayList<Block>();
    private final List<Block> roofSlabs = new ArrayList<Block>();
    private final List<Block> roofStairs = new ArrayList<Block>();
    private final List<Block> planksBlocks = new ArrayList<Block>();
    private final List<Block> planksSlabs = new ArrayList<Block>();
    private final List<Block> planksStairs = new ArrayList<Block>();
    private final List<Block> fences = new ArrayList<Block>();
    private final List<Block> walls = new ArrayList<Block>();
    private final List<Block> gates = new ArrayList<Block>();
    private final List<Block> logs = new ArrayList<Block>();
    private final List<Block> bark = new ArrayList<Block>();
    private final List<Block> stoneBlocks = new ArrayList<Block>();
    private final List<Block> stoneSlabs = new ArrayList<Block>();
    private final List<Block> stoneStairs = new ArrayList<Block>();
    private final List<Block> glowingBlocks = new ArrayList<Block>();
    private final List<Block> wallLights = new ArrayList<Block>();
    private final List<Block> ceilingLights = new ArrayList<Block>();
    private final List<Block> floorLights = new ArrayList<Block>();
    private final List<Block> doors = new ArrayList<Block>();
    private final List<Block> trapdoors = new ArrayList<Block>();
    private final List<Block> platesStone = new ArrayList<Block>();
    private final List<Block> platesWood = new ArrayList<Block>();
    private final List<Block> glassBlocks = new ArrayList<Block>();
    private final List<Block> glassPanes = new ArrayList<Block>();
    private final List<Block> pots = new ArrayList<Block>();

    public CityPalette(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private CityPalette putBlocks(Block[] blocks, List<Block> list) {
        for (Block b : blocks) {
            list.add(b);
        }
        return this;
    }

    public CityPalette addFoundationBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationBlocks);
    }

    public CityPalette addFoundationSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationSlabs);
    }

    public CityPalette addFoundationStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationStairs);
    }

    public CityPalette addFoundationWalls(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationWalls);
    }

    public CityPalette addRoofBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.roofBlocks);
    }

    public CityPalette addRoofSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.roofSlabs);
    }

    public CityPalette addRoofStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.roofStairs);
    }

    public CityPalette addPlanksBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.planksBlocks);
    }

    public CityPalette addPlanksSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.planksSlabs);
    }

    public CityPalette addPlanksStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.planksStairs);
    }

    public CityPalette addFences(Block ... blocks) {
        return this.putBlocks(blocks, this.fences);
    }

    public CityPalette addWalls(Block ... blocks) {
        return this.putBlocks(blocks, this.walls);
    }

    public CityPalette addGates(Block ... blocks) {
        return this.putBlocks(blocks, this.gates);
    }

    public CityPalette addLogs(Block ... blocks) {
        return this.putBlocks(blocks, this.logs);
    }

    public CityPalette addBark(Block ... blocks) {
        return this.putBlocks(blocks, this.bark);
    }

    public CityPalette addStoneBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneBlocks);
    }

    public CityPalette addStoneSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneSlabs);
    }

    public CityPalette addStoneStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneStairs);
    }

    public CityPalette addGlowingBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.glowingBlocks);
    }

    public CityPalette addWallLights(Block ... blocks) {
        return this.putBlocks(blocks, this.wallLights);
    }

    public CityPalette addCeilingLights(Block ... blocks) {
        return this.putBlocks(blocks, this.ceilingLights);
    }

    public CityPalette addFloorLights(Block ... blocks) {
        return this.putBlocks(blocks, this.floorLights);
    }

    public CityPalette addDoors(Block ... blocks) {
        return this.putBlocks(blocks, this.doors);
    }

    public CityPalette addTrapdoors(Block ... blocks) {
        return this.putBlocks(blocks, this.trapdoors);
    }

    public CityPalette addStonePlates(Block ... blocks) {
        return this.putBlocks(blocks, this.platesStone);
    }

    public CityPalette addWoodPlates(Block ... blocks) {
        return this.putBlocks(blocks, this.platesWood);
    }

    public CityPalette addGlassBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.glassBlocks);
    }

    public CityPalette addGlassPanes(Block ... blocks) {
        return this.putBlocks(blocks, this.glassPanes);
    }

    public CityPalette addPotsPanes(Block ... blocks) {
        return this.putBlocks(blocks, this.pots);
    }

    private Block getRandomBlock(BlockState state, List<Block> list) {
        if (list.isEmpty()) {
            return state.getBlock();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        String seed = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getPath();
        RANDOM.setSeed((long)seed.hashCode());
        return list.get(RANDOM.nextInt(list.size()));
    }

    private BlockState getFullState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return list.get(0).defaultBlockState();
        }
        return this.getRandomBlock(input, list).defaultBlockState();
    }

    private BlockState getSlabState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return this.copySlab(input, list.get(0));
        }
        return this.copySlab(input, this.getRandomBlock(input, list));
    }

    private BlockState getStairState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return this.copyStair(input, list.get(0));
        }
        return this.copyStair(input, this.getRandomBlock(input, list));
    }

    private BlockState copySlab(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)block.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)((SlabType)source.getValue((Property)SlabBlock.TYPE)))).setValue((Property)SlabBlock.WATERLOGGED, (Comparable)((Boolean)source.getValue((Property)SlabBlock.WATERLOGGED)));
        return state;
    }

    private BlockState copyStair(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)((Direction)source.getValue((Property)StairBlock.FACING)))).setValue((Property)StairBlock.HALF, (Comparable)((Half)source.getValue((Property)StairBlock.HALF)))).setValue((Property)StairBlock.SHAPE, (Comparable)((StairsShape)source.getValue((Property)StairBlock.SHAPE)))).setValue((Property)StairBlock.WATERLOGGED, (Comparable)((Boolean)source.getValue((Property)StairBlock.WATERLOGGED)));
        return state;
    }

    private BlockState copyWall(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)WallBlock.EAST_WALL, (Comparable)((WallSide)source.getValue((Property)WallBlock.EAST_WALL)))).setValue((Property)WallBlock.NORTH_WALL, (Comparable)((WallSide)source.getValue((Property)WallBlock.NORTH_WALL)))).setValue((Property)WallBlock.SOUTH_WALL, (Comparable)((WallSide)source.getValue((Property)WallBlock.SOUTH_WALL)))).setValue((Property)WallBlock.WEST_WALL, (Comparable)((WallSide)source.getValue((Property)WallBlock.WEST_WALL)))).setValue((Property)WallBlock.UP, (Comparable)((Boolean)source.getValue((Property)WallBlock.UP)))).setValue((Property)StairBlock.WATERLOGGED, (Comparable)((Boolean)source.getValue((Property)StairBlock.WATERLOGGED)));
        return state;
    }

    private BlockState copyFence(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)FenceBlock.EAST, (Comparable)((Boolean)source.getValue((Property)FenceBlock.EAST)))).setValue((Property)FenceBlock.NORTH, (Comparable)((Boolean)source.getValue((Property)FenceBlock.NORTH)))).setValue((Property)FenceBlock.SOUTH, (Comparable)((Boolean)source.getValue((Property)FenceBlock.SOUTH)))).setValue((Property)FenceBlock.WEST, (Comparable)((Boolean)source.getValue((Property)FenceBlock.WEST)))).setValue((Property)FenceBlock.WATERLOGGED, (Comparable)((Boolean)source.getValue((Property)FenceBlock.WATERLOGGED)));
        return state;
    }

    private BlockState copyGate(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)FenceGateBlock.IN_WALL, (Comparable)((Boolean)source.getValue((Property)FenceGateBlock.IN_WALL)))).setValue((Property)FenceGateBlock.OPEN, (Comparable)((Boolean)source.getValue((Property)FenceGateBlock.OPEN)))).setValue((Property)FenceGateBlock.POWERED, (Comparable)((Boolean)source.getValue((Property)FenceGateBlock.POWERED)))).setValue((Property)FenceGateBlock.FACING, (Comparable)((Direction)source.getValue((Property)FenceGateBlock.FACING)));
        return state;
    }

    private BlockState copyPillar(BlockState source, Block block) {
        BlockState state = (BlockState)block.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)source.getValue((Property)RotatedPillarBlock.AXIS)));
        return state;
    }

    private BlockState copyLanternWall(BlockState source, Block block) {
        if (source.getBlock() instanceof BlockSmallLantern && !(block instanceof BlockSmallLantern)) {
            Direction facing = (Direction)source.getValue((Property)BlockSmallLantern.FACING);
            BlockState state = block.defaultBlockState();
            if (block instanceof WallTorchBlock) {
                return (BlockState)state.setValue((Property)WallTorchBlock.FACING, (Comparable)facing);
            }
            return state;
        }
        return source;
    }

    private BlockState copyLanternCeiling(BlockState source, Block block) {
        if (source.getBlock() instanceof BlockSmallLantern && !(block instanceof BlockSmallLantern)) {
            BlockState state = block.defaultBlockState();
            if (block instanceof LanternBlock) {
                return (BlockState)state.setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return source;
    }

    private BlockState copyDoor(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)DoorBlock.FACING, (Comparable)((Direction)source.getValue((Property)DoorBlock.FACING)))).setValue((Property)DoorBlock.HALF, (Comparable)((DoubleBlockHalf)source.getValue((Property)DoorBlock.HALF)))).setValue((Property)DoorBlock.HINGE, (Comparable)((DoorHingeSide)source.getValue((Property)DoorBlock.HINGE)))).setValue((Property)DoorBlock.OPEN, (Comparable)((Boolean)source.getValue((Property)DoorBlock.OPEN)))).setValue((Property)DoorBlock.POWERED, (Comparable)((Boolean)source.getValue((Property)DoorBlock.POWERED)));
        return state;
    }

    private BlockState copyTrapdoor(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)TrapDoorBlock.FACING, (Comparable)((Direction)source.getValue((Property)TrapDoorBlock.FACING)))).setValue((Property)TrapDoorBlock.HALF, (Comparable)((Half)source.getValue((Property)TrapDoorBlock.HALF)))).setValue((Property)TrapDoorBlock.OPEN, (Comparable)((Boolean)source.getValue((Property)TrapDoorBlock.OPEN)))).setValue((Property)TrapDoorBlock.POWERED, (Comparable)((Boolean)source.getValue((Property)TrapDoorBlock.POWERED)))).setValue((Property)TrapDoorBlock.WATERLOGGED, (Comparable)((Boolean)source.getValue((Property)TrapDoorBlock.WATERLOGGED)));
        return state;
    }

    private BlockState copyPane(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)IronBarsBlock.EAST, (Comparable)((Boolean)source.getValue((Property)IronBarsBlock.EAST)))).setValue((Property)IronBarsBlock.NORTH, (Comparable)((Boolean)source.getValue((Property)IronBarsBlock.NORTH)))).setValue((Property)IronBarsBlock.SOUTH, (Comparable)((Boolean)source.getValue((Property)IronBarsBlock.SOUTH)))).setValue((Property)IronBarsBlock.WEST, (Comparable)((Boolean)source.getValue((Property)IronBarsBlock.WEST)))).setValue((Property)IronBarsBlock.WATERLOGGED, (Comparable)((Boolean)source.getValue((Property)IronBarsBlock.WATERLOGGED)));
        return state;
    }

    public BlockState getFoundationBlock(BlockState input) {
        return this.getFullState(input, this.foundationBlocks);
    }

    public BlockState getFoundationSlab(BlockState input) {
        return this.getSlabState(input, this.foundationSlabs);
    }

    public BlockState getFoundationStair(BlockState input) {
        return this.getStairState(input, this.foundationStairs);
    }

    public BlockState getFoundationWall(BlockState input) {
        if (this.foundationWalls.isEmpty()) {
            return input;
        }
        if (this.foundationWalls.size() == 1) {
            return this.copyWall(input, this.foundationWalls.get(0));
        }
        return this.copyWall(input, this.getRandomBlock(input, this.foundationWalls));
    }

    public BlockState getRoofBlock(BlockState input) {
        return this.getFullState(input, this.roofBlocks);
    }

    public BlockState getRoofSlab(BlockState input) {
        return this.getSlabState(input, this.roofSlabs);
    }

    public BlockState getRoofStair(BlockState input) {
        return this.getStairState(input, this.roofStairs);
    }

    public BlockState getPlanksBlock(BlockState input) {
        return this.getFullState(input, this.planksBlocks);
    }

    public BlockState getPlanksSlab(BlockState input) {
        return this.getSlabState(input, this.planksSlabs);
    }

    public BlockState getPlanksStair(BlockState input) {
        return this.getStairState(input, this.planksStairs);
    }

    public BlockState getFence(BlockState input) {
        if (this.fences.isEmpty()) {
            return input;
        }
        if (this.fences.size() == 1) {
            return this.copyFence(input, this.fences.get(0));
        }
        return this.copyFence(input, this.getRandomBlock(input, this.fences));
    }

    public BlockState getWall(BlockState input) {
        if (this.walls.isEmpty()) {
            return input;
        }
        if (this.walls.size() == 1) {
            return this.copyWall(input, this.walls.get(0));
        }
        return this.copyWall(input, this.getRandomBlock(input, this.walls));
    }

    public BlockState getGate(BlockState input) {
        if (this.gates.isEmpty()) {
            return input;
        }
        if (this.gates.size() == 1) {
            return this.copyGate(input, this.gates.get(0));
        }
        return this.copyGate(input, this.getRandomBlock(input, this.gates));
    }

    public BlockState getLog(BlockState input) {
        if (this.logs.isEmpty()) {
            return input;
        }
        if (this.logs.size() == 1) {
            return this.copyPillar(input, this.logs.get(0));
        }
        return this.copyPillar(input, this.getRandomBlock(input, this.logs));
    }

    public BlockState getBark(BlockState input) {
        if (this.bark.isEmpty()) {
            return input;
        }
        if (this.bark.size() == 1) {
            return this.copyPillar(input, this.bark.get(0));
        }
        return this.copyPillar(input, this.getRandomBlock(input, this.bark));
    }

    public BlockState getStoneBlock(BlockState input) {
        return this.getFullState(input, this.stoneBlocks);
    }

    public BlockState getStoneSlab(BlockState input) {
        return this.getSlabState(input, this.stoneSlabs);
    }

    public BlockState getStoneStair(BlockState input) {
        return this.getStairState(input, this.stoneStairs);
    }

    public BlockState getGlowingBlock(BlockState input) {
        return this.getFullState(input, this.glowingBlocks);
    }

    public BlockState getWallLight(BlockState input) {
        if (this.wallLights.isEmpty()) {
            return input;
        }
        if (this.wallLights.size() == 1) {
            return this.copyLanternWall(input, this.bark.get(0));
        }
        return this.copyLanternWall(input, this.getRandomBlock(input, this.wallLights));
    }

    public BlockState getCeilingLight(BlockState input) {
        return this.copyLanternCeiling(input, this.getRandomBlock(input, this.ceilingLights));
    }

    public BlockState getFloorLight(BlockState input) {
        return this.getFullState(input, this.ceilingLights);
    }

    public BlockState getDoor(BlockState input) {
        return this.copyDoor(input, this.getRandomBlock(input, this.doors));
    }

    public BlockState getTrapdoor(BlockState input) {
        return this.copyTrapdoor(input, this.getRandomBlock(input, this.trapdoors));
    }

    public BlockState getWoodenPlate(BlockState input) {
        return this.getFullState(input, this.platesWood);
    }

    public BlockState getStonePlate(BlockState input) {
        return this.getFullState(input, this.platesStone);
    }

    public BlockState getGlassBlock(BlockState input) {
        return this.getFullState(input, this.glassBlocks);
    }

    public BlockState getGlassPane(BlockState input) {
        return this.copyPane(input, this.getRandomBlock(input, this.glassPanes));
    }

    public BlockState getPot(BlockState input) {
        return this.getFullState(input, this.pots);
    }

    public BlockState getPlant(BlockState input) {
        String seed = BuiltInRegistries.BLOCK.getKey((Object)input.getBlock()).getPath();
        RANDOM.setSeed((long)seed.hashCode());
        return (BlockState)NetherBlocks.POTTED_PLANT.defaultBlockState().setValue(BlockPottedPlant.PLANT, (Comparable)((Object)BNBlockProperties.PottedPlantShape.values()[RANDOM.nextInt(BNBlockProperties.PottedPlantShape.values().length)]));
    }
}

