/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherStructurePieces;
import org.betterx.betternether.world.structures.piece.CustomPiece;

public class CavePiece
extends CustomPiece {
    private static final BlockState LAVA = Blocks.LAVA.defaultBlockState();
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(927649L);
    private final BlockPos center;
    private final int radius;
    private final int radSqr;

    public CavePiece(BlockPos center, int radius, RandomSource random, BoundingBox blockBox) {
        super(NetherStructurePieces.CAVE_PIECE, random.nextInt(), CavePiece.makeBoundingBox(center, radius));
        this.center = center.immutable();
        this.radius = radius;
        this.radSqr = radius * radius;
    }

    public CavePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(NetherStructurePieces.CAVE_PIECE, tag);
        this.center = NbtUtils.readBlockPos((CompoundTag)tag, (String)"center").orElse(BlockPos.ZERO);
        this.radius = tag.getInt("radius");
        this.radSqr = this.radius * this.radius;
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        tag.put("center", NbtUtils.writeBlockPos((BlockPos)this.center));
        tag.putInt("radius", this.radius);
    }

    public void postProcess(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        BlockState bottom = LAVA;
        if (!world.dimensionType().hasCeiling()) {
            bottom = Blocks.NETHERRACK.defaultBlockState();
        }
        for (int x = blockBox.minX(); x <= blockBox.maxX(); ++x) {
            int px = x - this.center.getX();
            px *= px;
            for (int z = blockBox.minZ(); z <= blockBox.maxZ(); ++z) {
                int pz = z - this.center.getZ();
                pz *= pz;
                for (int y = blockBox.minY(); y <= blockBox.maxY(); ++y) {
                    int py = y - this.center.getY() << 1;
                    if (!((double)(px + (py *= py) + pz) <= (double)this.radSqr + NOISE.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * 800.0)) continue;
                    POS.set(x, y, z);
                    if (y > 31) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, CAVE_AIR);
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, bottom);
                }
            }
        }
    }

    private static BoundingBox makeBoundingBox(BlockPos center, int radius) {
        int x1 = center.getX() - radius;
        int x2 = center.getX() + radius;
        int minY = Math.max(22, center.getY() - radius);
        int maxY = Math.min(96, center.getY() + radius);
        int z1 = center.getZ() - radius;
        int z2 = center.getZ() + radius;
        return new BoundingBox(x1, minY, z1, x2, maxY, z2);
    }
}

